#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/tools/inspect/inspectLib.sh
# **************************************************************************** #
# Function Name: CheckAndExecCommand
# Description: Entrance of this scripts
# Parameter:
# Return:
# **************************************************************************** #
function CheckAndExecCommand()
{
    #除了CheckClusterStatus，其余的函退出的值要么为0(成功)，要么为1(失败)
    #CHECK_CMD -- node ip
    CHECK_CMD=$1
    case $2 in
        clusterStatus)
            CheckClusterStatus "${CHECK_CMD}";;
        memory)
            CheckMemInfo "${CHECK_CMD}";;
        diskfree)
            CheckDiskFree "${CHECK_CMD}";;
        cpuStatus)
            CheckCpuStatus "${CHECK_CMD}";;
        cps-monitor)
            CheckCpsMonitor "${CHECK_CMD}";;
        cms)
            CheckCms "${CHECK_CMD}";;
        zookeeper)
            CheckZookeeper "${CHECK_CMD}";;
        gaussdb)
            CheckGaussdb "${CHECK_CMD}";;
        omm-ha)
            CheckOmmha "${CHECK_CMD}";;
        haproxy)
            CheckHaproxy "${CHECK_CMD}";;
        rabbitmq)
            CheckRabbitmq "${CHECK_CMD}";;
        scagent)
            CheckScagent "${CHECK_CMD}";;
        resource_manager)
            CheckResourceManager "${CHECK_CMD}";;
        karbor)
            CheckKarbor "${CHECK_CMD}";;
        defaultPwd)
            CheckDefaultPwd "${CHECK_CMD}";;
        alarm)
            CheckAlarm "${CHECK_CMD}";;
        *)
            echo "${CHECK_CMD} $3: N/A"
            exit 10;; #不涉及
    esac
}
# **************************************************************************** #
# Function Name: CheckClusterStatus
# Description: 检查集群状态
# Parameter:
# Return:
# **************************************************************************** #
function CheckClusterStatus()
{
    IFS="," read -r -a NODE_LIST <<< "$(get_info manage_ip_list)"
    for node in "${NODE_LIST[@]}";do
        if ! check_logon "${node}" >>/dev/null;then
            msg=${msg}'||'${node}:'down'
            ret=1
        else
            msg=${msg}'||'${node}:'up'
        fi
    done
    echo "${msg}"
    exit ${ret}
}
# **************************************************************************** #
# Function Name: CheckMemInfo
# Description: 检查内存状态
# Parameter:
# Return:
# **************************************************************************** #
function CheckMemInfo()
{
    freeSpaceMB=$(free -m |awk '/Mem/ {print $2-$3}')
    msg="$1 Free Memory":${freeSpaceMB}'MB'
    if [[ ${freeSpaceMB} -lt 1024 ]];then
        ret=1
    fi
    echo "${msg}"
    exit ${ret}
}
# **************************************************************************** #
# Function Name: CheckDiskFree
# Description: 检查disk分区目录状态
# Parameter:
# Return:
# **************************************************************************** #
function CheckDiskFree()
{
    #/var/log disk free
    echoPathFree "/var/log" "$1"
    echoPathFree "/opt" "$1"
    exit $?
}
function echoPathFree()
{
    if [[ ! -d $1 ]];then
        echo "$1 path: Not Exist"
        return 1
    fi
    freeSpaceMB=$(df -m "$1"|sed -n '2p'|awk '{print $4}')
    [[ ${freeSpaceMB} -lt 1024 ]] && ret=1
    msg="$2 $1 Disk Free":${freeSpaceMB}'MB'
    echo "${msg}"
    return ${ret}
}
# **************************************************************************** #
# Function Name: CheckCpuStatus
# Description: 检查cpu使用率状态
# Parameter:
# Return:
# **************************************************************************** #
function CheckCpuStatus()
{
    #cpu可用资源比例
    cpuTotal=$(top -b -n 1 |grep 'load average'|awk -F',' '{print $NF}')
    coreNum=$(grep -c processor <  /proc/cpuinfo)
    cpu=$(echo "${cpuTotal} ${coreNum}" | awk '{printf("%d",(1-$1/$2)*100)}')
    if [[ ${cpu} -le 20 ]];then
        ret=1
    fi
    echo "$1 Cpu Idle:${cpu}%"
    exit ${ret}
}
# **************************************************************************** #
# Function Name: CheckCpsMonitor
# Description: 检查cps-monitor组件
# Parameter:
# Return:
# **************************************************************************** #
function CheckCpsMonitor()
{
    if [[ ! -f "/opt/huawei/dj/tools/cps-monitor/inspect.sh" ]];then
        echo "$1 cps-monitor: N/A"
        exit 10 #不涉及
    fi
    check 'cps_monitor_process'                   "$1 cps-monitor" "cps-monitor"
    exit $?
}
# **************************************************************************** #
# Function Name: CheckZookeeper
# Description: 检查zookeeper组件
# Parameter:
# Return:
# **************************************************************************** #
function CheckZookeeper()
{
    if [ ! -f "/opt/huawei/dj/tools/zookeeper/inspect.sh" ];then
        echo "$1 zookeeper: N/A"
        exit 10 #不涉及
    fi
    check 'zookeeper_process'                   "$1 zookeeper" "zookeeper"
    exit $?
}
# **************************************************************************** #
# Function Name: CheckGaussdb
# Description: 检查gaussdb组件
# Parameter:
# Return:
# **************************************************************************** #
function CheckGaussdb()
{
    if [[ ! -f "/opt/huawei/dj/tools/gaussdb/inspect.sh" ]];then
        echo "$1 gaussdb: N/A"
        exit 10 #不涉及
    fi
    check 'gaussdb_process'                         "$1 gaussdb" "gaussdb"
    exit $?
}
# **************************************************************************** #
# Function Name: CheckOmmha
# Description: 检查omm-ha组件
# Parameter:
# Return:
# **************************************************************************** #
function CheckOmmha()
{
    if [[ ! -f "/opt/huawei/dj/tools/omm-ha/inspect.sh" ]];then
        echo "$1 omm-ha: N/A"
        exit 10 #不涉及
    fi
    check 'omm_ha_process'                         "$1 omm-ha" "omm-ha"
    exit $?
}
# **************************************************************************** #
# Function Name: CheckHaproxy
# Description: 检查haproxy组件
# Parameter:
# Return:
# **************************************************************************** #
function CheckHaproxy()
{
    if [[ ! -f "/opt/huawei/dj/tools/haproxy/inspect.sh" ]];then
        echo "$1 haproxy: N/A"
        exit 10 #不涉及
    fi
    check 'haproxy'                 "$1 haproxy" "haproxy"
    exit $?
}
# **************************************************************************** #
# Function Name: CheckRabbitmq
# Description: 检查rabbitmq组件
# Parameter:
# Return:
# **************************************************************************** #
function CheckRabbitmq()
{
    if [ ! -f "/opt/huawei/dj/tools/rabbitmq/inspect.sh" ];then
        echo "$1 rabbitmq: N/A"
        exit 10 #不涉及
    fi
    check 'rabbitmq_process'                   "$1 rabbitmq" "rabbitmq"
    exit $?
}
# **************************************************************************** #
# Function Name: CheckCms
# Description: 检查cms组件
# Parameter:
# Return:
# **************************************************************************** #
function CheckCms ()
{
    if [[ ! -f "/opt/huawei/dj/tools/cms/inspect.sh" ]];then
        echo "$1 cms: N/A"
        exit 10 #不涉及
    fi
    check 'cms_process'                         "$1 cms" "cms"
    exit $?
}
# **************************************************************************** #
# Function Name: CheckResourceManager
# Description: 检查resource_manager组件
# Parameter:
# Return:
# **************************************************************************** #
function CheckResourceManager ()
{
    if [ ! -f "/opt/huawei/dj/tools/resource_manager/inspect.sh" ];then
        echo "$1 resource_manager: N/A"
        exit 10 #不涉及
    fi

    check 'resource_manager'      "$1 resource_manager" "resource_manager"
    exit $?
}
# **************************************************************************** #
# Function Name: CheckScagent
# Description: 检查scagent组件
# Parameter:
# Return:
# **************************************************************************** #
function CheckScagent()
{
    if [[ ! -f "/opt/huawei/dj/tools/scagent/inspect.sh" ]];then
        echo "$1 scagent: N/A"
        exit 10 #不涉及
    fi
    check 'scagent_process'                         "$1 scagent" "scagent"
    exit $?
}
# **************************************************************************** #
# Function Name: CheckRabbitmq
# Description: 检查karbor组件
# Parameter:
# Return:
# **************************************************************************** #
function CheckKarbor()
{
    if [[ ! -f "/opt/huawei/dj/tools/karbor/inspect.sh" ]];then
        echo "$1 karbor: N/A"
        exit 10 #不涉及
    fi
    check 'karbor_api_process'                   "$1 karbor-api" "karbor" \
          'karbor_protection_process'            "$1 karbor-protection" "karbor" \
          'karbor_operation_process'             "$1 karbor-operation" "karbor" \
          'service_status'                       "$1 service_status" "karbor" \
          'connect_status'                       "$1 connect_status" "karbor"
    exit $?
}
# **************************************************************************** #
# Function Name: CheckDefaultPwd
# Description: 检查默认密码
# Parameter:
# Return:
# **************************************************************************** #
function CheckDefaultPwd()
{
    default_pwd_decrypt=$(decrypt_pwd "$(get_info default_user_pwd)")
    haproxy_user_info=$(get_cms_info haproxy.db_user_pass)
    haproxy_pwd=$(get_dict_info "${haproxy_user_info}" "haproxy_db_pass")
    haproxy_pwd_decrypt=$(decrypt_pwd "${haproxy_pwd}")
    karbor_user_info=$(get_cms_info karbor.db_user_pass)
    karbor_pwd=$(get_dict_info "${karbor_user_info}" "karbor_db_pass")
    karbor_pwd_decrypt=$(decrypt_pwd "${karbor_pwd}")
    rabbitmq_pwd=$(get_cms_info "rabbitmq.pwd")
    rabbitmq_pwd_decrypt=$(decrypt_pwd "${rabbitmq_pwd}")
    cms_pwd=$(grep 'connection' /opt/huawei/dj/etc/cms/cms.conf | awk -F ':' '{print $3}' | awk -F '@' '{print $1}')
    cms_pwd_decrypt=$(decrypt_pwd "${cms_pwd}")
    zookeeper_user_info=$(get_cms_info "ascagent.zookeeper.zk_client_pwd")
    zookeeper_pwd=$(get_dict_info "${zookeeper_user_info}" "zookeeper_auth")
    zookeeper_pwd_decrypt=$(decrypt_pwd "${zookeeper_pwd}")
    gaussdb_pwd_decrypt=$(decrypt_pwd "$(get_info gaussdb_admin_pwd)")
    if [[ "${default_pwd_decrypt}" == "${haproxy_pwd_decrypt}" ]]; then
      echo "The password of haproxy uses the default one."
      ret=1
    fi
    if [[ "${default_pwd_decrypt}" == "${karbor_pwd_decrypt}" ]]; then
      echo "The password of karbor uses the default one."
      ret=1
    fi
    if [[ "${default_pwd_decrypt}" == "${rabbitmq_pwd_decrypt}" ]]; then
      echo "The password of rabbitmq uses the default one."
      ret=1
    fi
    if [[ "${default_pwd_decrypt}" == "${cms_pwd_decrypt}" ]]; then
      echo "The password of cms uses the default one."
      ret=1
    fi
    if [[ "${default_pwd_decrypt}" == "${zookeeper_pwd_decrypt}" ]]; then
      echo "The password of zookeeper uses the default one."
      ret=1
    fi
    if [[ "${default_pwd_decrypt}" == "${gaussdb_pwd_decrypt}" ]]; then
      echo "The password of gaussdb_admin uses the default one."
      ret=1
    fi
    exit ${ret}
}
# **************************************************************************** #
# Function Name: CheckAlarm
# Description: 检查alarm组件
# Parameter:
# Return:
# **************************************************************************** #
function CheckAlarm()
{
    if [ ! -f "/opt/huawei/dj/tools/alarm/inspect.sh" ];then
        echo "$1 alarm: N/A"
        exit 10 #不涉及
    fi

    check 'alarm'      "$1 alarm" "alarm"
    exit $?
}
################################  main  #########################################
CheckAndExecCommand "$1" "$2"
