#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"


function install_rsyslog()
{
    log_info "Init karbor rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/{system,operate}/karbor
    mkdir -p /var/log/huawei/dj/services/system/karbor/{karbor-api,karbor-apiControl}
    mkdir -p /var/log/huawei/dj/services/system/karbor/{karbor-protection,karbor-protectionControl}
    mkdir -p /var/log/huawei/dj/services/system/karbor/{karbor-operation,karbor-operationControl}
    log_info "Finish karbor rsyslog configuration."
}

function install_script()
{
    log_info "Init karbor script configuration."
    kangaroo_whl=$(find "${LINE_ROOT}/repo/self_developed" -type f -name "kangaroo*.whl")
    csbs_python -m pip install --no-deps --force-reinstall "${kangaroo_whl}"
    CHECK_RESULT $? "pip install kangaroo failed."
    log_info "Finish karbor script configuration."
}


function install_tools()
{
    log_info "Init karbor tools configuration."
    mkdir -p /opt/huawei/dj/{tools,etc}/karbor /opt/huawei/dj/bin/karbor/export_log
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/karbor
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/karbor/karbor-SetState.sh karbor-apiControl
    create_link /opt/huawei/dj/tools/karbor/karbor-SetState.sh karbor-protectionControl
    create_link /opt/huawei/dj/tools/karbor/karbor-SetState.sh karbor-operationControl
    log_info "Finish karbor tools configuration."
}

function install_version()
{
    log_info "Init karbor version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/karbor.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy karbor version Failed."
    log_info "Finish karbor version configuration."
}

function install_crontab()
{
    log_info "Init karbor crontab configuration."
    /usr/bin/cp -f "${CURRENT_PATH}/conf/crontab_karbor.conf" /etc/cron.d/
    CHECK_RESULT $? "Copy crontab_karbor failed."
    cmd_retry "service cron restart" 60 5
    CHECK_RESULT $? "Restart cron failed."
    log_info "Finish karbor crontab configuration."
}


function install_permission()
{
    log_info "Init karbor permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_modify_permission /var/log/huawei/dj
    set_modify_permission /opt/huawei/dj/etc/karbor/karbor.conf
    log_info "Finish karbor permission configuration."
}


function install_root()
{
    log_info "Init karbor root configuration."
    install_sudo_conf "${CURRENT_PATH}/conf/sudo_karbor_conf"
    install_root_tools karbor "${CURRENT_PATH}/root_sudo/update_crontab_conf.sh"
    log_info "Finish karbor root configuration."
}

function install_conf()
{
    log_info "Init karbor conf configuration."
    log_info "Finish karbor conf configuration."
}

log_info "Start karbor installation."
install_rsyslog
install_script
install_root
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish karbor installation."
