#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u openstack bash "$(readlink -f "$0")" "$@";exit $?
elif [[ ${UID} -ne 51001 ]];then
    echo "Please switch to user(openstack) for run." && exit 1
fi
source /opt/huawei/dj/inst/utils.sh
export LOG_TAG="karbor-run"

if [[ -z "$*" ]];then
    log_info "start delete_expired_export_file ..."
    kangaroo-manage delete_expired_export_file
    CHECK_RESULT $? "delete_expired_export_file failed."
    log_info "delete_expired_export_file successfully"
    return
fi
export_file="/opt/huawei/dj/bin/karbor/export_log/$1"
if [[ -f "${export_file}" ]] && [[ "$(realpath "${export_file}")" == "${export_file}" ]];then
    log_info "start delete export file $1"
    rm -f "${export_file}"
    CHECK_RESULT $? "delete export file $1 failed."
    log_info "delete export file $1 successfully"
else
    log_warn "export_file $1 is not exist on current node."
fi
