#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"
export LD_LIBRARY_PATH=/opt/huawei/dj/bin/ha/libs:${LD_LIBRARY_PATH}
HA_CONFIG_SH="/opt/huawei/dj/bin/ha/module/hacom/script/config_ha.sh"

function config_single_node()
{
    log_info "HA: begin to config single node omm-ha."
    bash ${HA_CONFIG_SH} -m single
    CHECK_RESULT $? "Error to config omm_ha in single node."
}

function judge_active_comp()
{
    install_nodes=$(get_info omm-ha_nodes)
    active_node=${install_nodes%%,*}
    if [[ "$1" == "${active_node}" ]];then
        echo "0"
    else
        echo "1"
    fi
}

function config_peer_node()
{
    log_info "HA: begin to config peer node omm-ha."
    local_ip=$(get_info manage_ip)
    default_gateway=$(get_info default_gateway)
    case $(judge_active_comp "${local_ip}") in
    0) # active mode
        sh ${HA_CONFIG_SH} -m double -l ha1 -p ha2 -b ha1:"${local_ip}":25555,ha2:$1:25555 \
        -s ha1:"${local_ip}":26666,ha2:$1:26666 -g "${default_gateway}"  -j active
        CHECK_RESULT $? "Active add node failed."
    ;;
    1) # standby mode
        sh ${HA_CONFIG_SH} -m double -l ha2 -p ha1 -b ha2:"${local_ip}":25555,ha1:$1:25555 \
        -s ha2:"${local_ip}":26666,ha1:$1:26666 -g "${default_gateway}"  -j standby
        CHECK_RESULT $? "Standby add node failed."
    ;;
    *)
        log_error "The mode get form host error."
        exit 1
    ;;
    esac
}

log_info "HA: begin to config omm-ha."
bash ${HA_CONFIG_SH} -f /var/log/huawei/dj/services/system
CHECK_RESULT $? "HA: failed to  config runlog path"
log_info "HA: begin to config scriptlog path."
bash ${HA_CONFIG_SH} -k /var/log/huawei/dj/services/system
CHECK_RESULT $? "HA: failed to config scriptlog path"
log_info "HA: begin to config core path."
bash ${HA_CONFIG_SH} -o /var/log/huawei/dj/services/system
CHECK_RESULT $? "HA: failed to config core path"
ha_peer_node=$(get_info ha_peer_node)
if [[ "${ha_peer_node}" != "None" ]];then
    config_peer_node "${ha_peer_node}"
else
    config_single_node
fi
sed -i "s#GAUSSDB_FLOAT_IP#$(get_info gaussdb_float_ip)#g"  /opt/huawei/root_tools/omm-ha/update_ip_conf.sh
CHECK_RESULT $? "HA: failed to config GAUSSDB_FLOAT_IP"
sed -i "s#HAPROXY_FLOAT_IP#$(get_info haproxy_float_ip)#g"  /opt/huawei/root_tools/omm-ha/update_ip_conf.sh
CHECK_RESULT $? "HA: failed to config HAPROXY_FLOAT_IP"
log_info "HA: Finish to config  omm-ha."
