#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function upgrade_cps_monitor()
{
    log_info "begin omm-ha Upgrade action."
    sh "${CURRENT_PATH}/uninstall.sh"
    CHECK_RESULT $? "failed to uninstall old omm-ha"
    sh "${CURRENT_PATH}/merge.sh"
    CHECK_RESULT $? "failed to merge new omm-ha"
    sh "${CURRENT_PATH}/install.sh"
    CHECK_RESULT $? "failed to install new omm-ha"
    sh "${CURRENT_PATH}/config.sh"
    CHECK_RESULT $? "failed to config new omm-ha"
    tar -P --extract --file="${LINE_ROOT}/old_version_data.tar.gz" /opt/huawei/dj/bin/ha/module/harm/plugin
    CHECK_RESULT $? "failed to restore harm plugin new omm-ha"
    tar -P --extract --file="${LINE_ROOT}/old_version_data.tar.gz" /opt/huawei/dj/bin/arbitrationtool/conf
    CHECK_RESULT $? "failed to restore arbitrationtool conf new omm-ha"
    sh "${CURRENT_PATH}/start.sh"
    CHECK_RESULT $? "failed to config new omm-ha"
    log_info "Finish omm-ha Upgrade action."
}

log_info "begin omm-ha Upgrade."
upgrade_cps_monitor
touch "${CURRENT_PATH}/omm-ha_upgrade_finish"
log_info "Upgrade omm-ha success."