#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

function install_rsyslog()
{
    log_info "Init rabbitmq rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/rabbitmq
    log_info "Finish rabbitmq rsyslog configuration."
}

function install_script()
{
    log_info "Init rabbitmq script configuration."
    erlang_rpm=$(find "${LINE_ROOT}/repo/third_party" -type f -name "erlang-*.rpm")
    rpm -Uivh --force --nodeps "${erlang_rpm}"
    CHECK_RESULT $? "Install erlang rpm Failed."
    rabbitmq_xz=$(find "${LINE_ROOT}/repo/third_party" -type f -name "rabbitmq-server-*.tar.xz")
    if [[ ! -f "${LINE_ROOT}/repo/third_party/$(basename "${rabbitmq_xz}" .xz)" ]];then
        xz -dk "${rabbitmq_xz}" && CHECK_RESULT $? "xz rabbitmq server Failed."
    fi
    install_dir=$(mktemp -d /tmp/nameXXXXX)
    tar -xf "${LINE_ROOT}/repo/third_party/$(basename "${rabbitmq_xz}" .xz)" --no-same-owner -C "${install_dir}"
    CHECK_RESULT $? "tar rabbitmq server Failed."
    rabbitmq_dir=$(find "${install_dir}" -maxdepth 1 -type d -name "rabbitmq*")
    /usr/bin/mv -f  "${rabbitmq_dir}"  /opt/huawei/dj/bin/rabbitmq
    CHECK_RESULT $? "Install rabbitmq server Failed."
    rm -rf "${install_dir}"
    echo "karbor_rabbit_cookie" > /home/openstack/.erlang.cookie
    log_info "Finish rabbitmq script configuration."
}


function install_tools()
{
    log_info "Init rabbitmq tools configuration."
    mkdir -p /opt/huawei/dj/{tools,etc}/rabbitmq
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/rabbitmq
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/rabbitmq/rabbitmqControl.sh
    log_info "Finish rabbitmq tools configuration."
}

function install_conf()
{
    log_info "Init rabbitmq conf configuration."
    mkdir -p /opt/huawei/dj/etc/rabbitmq
    /usr/bin/cp -f "${CURRENT_PATH}/conf/rabbitmq.config" /opt/huawei/dj/etc/rabbitmq
    CHECK_RESULT $? "Install rabbitmq config Failed."
    /usr/bin/cp -f "${CURRENT_PATH}/conf/rabbitmq-env.conf" /opt/huawei/dj/etc/rabbitmq
    CHECK_RESULT $? "Install rabbitmq env Failed."
    /usr/bin/cp -f "${CURRENT_PATH}/conf/key.para" /opt/huawei/dj/etc/rabbitmq
    CHECK_RESULT $? "Install rabbitmq key.para Failed."
    log_info "Finish rabbitmq conf configuration."
}

function install_version()
{
    log_info "Init rabbitmq version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/rabbitmq.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy rabbitmq version Failed."
    log_info "Finish rabbitmq version configuration."
}

function install_permission()
{
    log_info "Init rabbitmq permission configuration."
    set_common_permission /home/openstack/.erlang.cookie
    set_common_permission /var/log/huawei/dj
    set_common_permission /opt/huawei/dj
    set_modify_permission /var/log/huawei/dj
    set_modify_permission /opt/huawei/dj/bin/rabbitmq/etc/rabbitmq/rabbitmq.config
    set_modify_permission /opt/huawei/dj/bin/rabbitmq/etc/rabbitmq/rabbitmq-env.conf
    log_info "Finish rabbitmq permission configuration."
}

function install_root()
{
    log_info "Init rabbitmq root configuration."
    log_info "Finish rabbitmq root configuration."
}

function install_crontab()
{
    log_info "Init rabbitmq crontab configuration."
    log_info "Finish rabbitmq crontab configuration."
}

log_info "Start rabbitmq installation."
install_rsyslog
install_root
install_script
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish rabbitmq installation."
