#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"


function install_rsyslog()
{
    log_info "Init scagent rsyslog configuration."
    mkdir -p /var/log/huawei/dj/services/system/scagent
    log_info "Finish scagent rsyslog configuration."
}

function install_script()
{
    log_info "Init scagent uninstall configuration."
    scagent_whl=$(find "${LINE_ROOT}/repo/self_developed" -type f -name "scagent*.whl")
    csbs_python -m pip install --no-deps --force-reinstall "${scagent_whl}"
    CHECK_RESULT $? "pip install scagent failed."
    log_info "Finish scagent uninstall configuration."
}

function install_tools()
{
    log_info "Init scagent tools configuration."
    mkdir -p /opt/huawei/dj/tools/scagent
    tool_files=$(find "${CURRENT_PATH}/tools" -type f)
    while read -r tool_file;do
        /usr/bin/cp -f "${tool_file}" /opt/huawei/dj/tools/scagent
        CHECK_RESULT $? "Copy ${tool_file} failed"
    done <<< "${tool_files}"
    create_link /opt/huawei/dj/tools/scagent/scagentControl.sh
    log_info "Finish scagent tools configuration."
}

function install_conf()
{
    log_info "Init scagent conf configuration."
    log_info "Finish scagent conf configuration."
}

function install_version()
{
    log_info "Init scagent version configuration."
    mkdir -p /opt/huawei/dj/versions/
    /usr/bin/cp -f "${CURRENT_PATH}/conf/scagent.ver" /opt/huawei/dj/versions/
    CHECK_RESULT $? "Copy scagent version Failed."
    log_info "Finish scagent version configuration."
}

function install_permission()
{
    log_info "Init scagent permission configuration."
    set_common_permission /opt/huawei/dj
    set_common_permission /var/log/huawei/dj
    set_modify_permission /var/log/huawei/dj
    log_info "Finish scagent permission configuration."
}

function install_root()
{
    log_info "Init scagent root configuration."
    log_info "Finish scagent root configuration."
}

function install_crontab()
{
    log_info "Init scagent crontab configuration."
    log_info "Finish scagent crontab configuration."
}

log_info "Start scagent installation."
install_rsyslog
install_root
install_script
install_tools
install_conf
install_crontab
install_version
install_permission
log_info "Finish scagent installation."
