#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "$(dirname "${CURRENT_PATH}")")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="csbs_install"

log_info "Start zookeeper..."
zookeeper_auth_info=$(get_cms_info "$1")
zookeeper_auth=$(get_dict_info "${zookeeper_auth_info}" "zookeeper_auth")
if [[ -n "${zookeeper_auth}" ]];then
    sed -i "s/authData=.*/authData=${zookeeper_auth}/" /opt/huawei/dj/etc/zookeeper/zkClient.conf
else
    ZOOKEEPER_PWD=$(awk '{print $NF}' /opt/huawei/dj/DJSecurity/privkey/privkey.conf)
    sed -i "s/authData=.*/authData=${ZOOKEEPER_PWD}/" /opt/huawei/dj/etc/zookeeper/zkClient.conf
fi
zookeeperControl -A RESTART
CHECK_RESULT $? "Start zookeeper failed"
log_info "start zookeeper successfully."