#!/bin/bash

CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
LOG_TAG="proxy_install"
source ${LINE_ROOT}/bin/utils.sh

function add_user()
{
    if grep agentproxy /etc/passwd;then
        return 0
    fi
    local user_id=`get_info.py user_id operation_user`
    local group_id=`get_info.py group_id operation_user`
    groupadd -g ${group_id} agentproxy  > /dev/null 2>&1
    useradd -u ${user_id} -g agentproxy -s /sbin/nologin -d /home/agentproxy -m agentproxy > /dev/null 2>&1
    for group in $(grep "GROUPS" /etc/default/useradd  | cut -d= -f2 | sed "s/,/  /");do groupmod -R agentproxy ${group};done
    mkdir -p /home/agentproxy && chown -h agentproxy:agentproxy /home/agentproxy && chmod 700 /home/agentproxy
    usermod -G wheel agentproxy
    passwd -l agentproxy > /dev/null 2>&1
    chage -M -1 agentproxy > /dev/null 2>&1
    log_info "Add user agentproxy OK."

    useradd -u 51003 -g agentproxy -d /home/dpamanager -m dpamanager > /dev/null 2>&1
    usermod -G wheel dpamanager
    for group in $(grep "GROUPS" /etc/default/useradd  | cut -d= -f2 | sed "s/,/  /");do groupmod -R dpamanager ${group};done
    mkdir -p /home/dpamanager && chown -h dpamanager:agentproxy /home/dpamanager && chmod 700 /home/dpamanager
    log_info "Add user dpamanager  OK."
}

function set_agentproxy_for_sudo()
{
    mkdir -p /etc/sudoers.d
    touch /etc/sudoers.d/agentproxy
    chmod 400 /etc/sudoers.d/agentproxy
    sed -i "/Defaults  requiretty/c #Defaults  requiretty" /etc/sudoers
    cat /etc/sudoers | grep  '^#includedir /etc/sudoers.d$' > /dev/null 2>&1
    if [ $? -eq 0 ]; then
        log_info "#includedir /etc/sudoers.d is exist in file /etc/sudoers."
        return 0
    fi
    echo "#includedir /etc/sudoers.d" >> "/etc/sudoers"
}

function set_agentproxy_for_atd()
{
    echo "agentproxy" > /etc/at.allow
    service atd restart
    log_info "Set agentproxy for atd success."
}


function set_ip_forward()
{
    local port_info="net.ipv4.ip_local_port_range = 10240   65000"
    sed -i '/net.ipv4.ip_local_port_range =*/d' /etc/sysctl.conf
    echo "${port_info}" >> /etc/sysctl.conf

    sed -i '/net.ipv4.ip_nonlocal_bind=*/d' /etc/sysctl.conf
    sed -i '/net.ipv4.ip_forward=*/d' /etc/sysctl.conf
    sed -i '/net.ipv6.conf.all.forwarding=*/d' /etc/sysctl.conf
    sed -i '/net.ipv6.ip_nonlocal_bind=*/d' /etc/sysctl.conf
    sed -i '/net.ipv4.tcp_max_tw_buckets=*/d' /etc/sysctl.conf
    sed -i '/net.ipv4.tcp_fin_timeout=*/d' /etc/sysctl.conf
    sed -i '/net.ipv4.tcp_syncookies=*/d' /etc/sysctl.conf

    echo "net.ipv4.ip_nonlocal_bind=1"  >> /etc/sysctl.conf
    echo "net.ipv4.ip_forward=1"  >> /etc/sysctl.conf
    echo "net.ipv6.conf.all.forwarding=0"  >> /etc/sysctl.conf
    echo "net.ipv6.ip_nonlocal_bind=1"  >> /etc/sysctl.conf

    echo "net.ipv4.tcp_max_tw_buckets=5000"  >> /etc/sysctl.conf
    echo "net.ipv4.tcp_fin_timeout=15"  >> /etc/sysctl.conf
    echo "net.ipv4.tcp_syncookies=1"  >> /etc/sysctl.conf

    sysctl -p > /dev/null 2>&1
    log_info "Set net.ipv4.ip_forward finished."
}

function set_firewall()
{
    # stop and disable firewall
    systemctl stop firewalld
    systemctl disable firewalld
    log_info "disable firewalld finished."
    return 0
}

function config_agent_dir()
{
    /usr/bin/cp -f ${LINE_ROOT}/bin/proxy_ping.sh /usr/bin/proxy_ping
    /usr/bin/cp -f ${LINE_ROOT}/install_scripts/showsys.sh /usr/bin/showsys
    set_exec_permission /usr/bin/proxy_ping
    set_exec_permission /usr/bin/showsys
    set_exec_permission /usr/bin/get_info.py
    set_rw_permission /opt/huawei-data-protection > /dev/null 2>&1
    set_rw_permission /var/log/huawei-data-protection > /dev/null 2>&1
    chown -hR agentproxy:agentproxy /usr/bin/proxython > /dev/null 2>&1
    chown -hR root:root /usr/bin/python* > /dev/null 2>&1
    chown -hR agentproxy:agentproxy `readlink /usr/bin/proxython`* > /dev/null 2>&1
    for file in /usr/lib/libpython*;do
        set_exec_permission $file
    done
    log_info "Config agent dir finished."
}

function config_ntpd()
{
    sed -i "/^interface.*/d" /etc/ntp.conf
    echo "interface ignore wildcard" >> /etc/ntp.conf
    ip_str=`ifconfig eth0|grep inet|grep -v 127.0.0.1|grep -v inet6|awk '{print $2}'|tr -d "addr:"`
    ips=($ip_str)
    for ip in "${ips[@]}"
    do
        echo "interface listen $ip" >> /etc/ntp.conf
    done
    systemctl restart ntpd
    log_info "Config ntpd success."
}

function set_env_path()
{
    PATH="/usr/local/sbin:/usr/sbin:/usr/bin"
    sed -i "/export PATH=/d" $1
    echo "export PATH=$PATH" >> $1
}

add_user
set_agentproxy_for_sudo
set_agentproxy_for_atd
set_ip_forward
set_firewall
config_agent_dir
config_ntpd
set_env_path /root/.bashrc
set_env_path /home/dpamanager/.bashrc
log_info "OS config success."
