#!/bin/bash

CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
LOG_TAG="proxy_install"
source ${LINE_ROOT}/bin/utils.sh
SYS_PATH="/opt/huawei-data-protection"
CONF_PATH="/opt/huawei-data-protection/agentproxy/conf"

function read_ini()
{
    local key=`echo $2 | awk '{print toupper($0)}'`
    local sys_file=${SYS_PATH}/sys.ini
    local value=`awk -F '=' '/\['${key}'\]/{a=1}a==1&&$1~/'$1'/{print $2;exit}' ${sys_file}`
    echo "${value}" | sed "s/^[ \t]*//g" | sed "s/[ \t]*$//g"
}

function config_proxy()
{
    local current_region=$(read_ini current_region system)
    local timezone=$(read_ini timezone system)
    local ip_version=$(read_ini ip_version system)
    local agentproxy_nodes=$(read_ini agentproxy_nodes system)
    local haproxy_float_ip=$(read_ini haproxy_float_ip system)
    local net_mask=$(read_ini net_mask system)

    local kms_endpoint=$(read_ini kms_endpoint system)
    local oc_address=$(read_ini oc_address oc)
    local iam_address=$(read_ini iam_address iam)

    echo "${kms_endpoint}" | xargs | grep -E "^https://[-a-zA-Z0-9./:]+$">/dev/null
    CHECK_RESULT $? "Incorrect kmc endpoint. Please try again."

    echo "${oc_address}" | xargs | grep -E "^oc.[-a-zA-Z0-9./:]+$">/dev/null
    CHECK_RESULT $? "Incorrect oc endpoint. Please try again."

    sed -i "s#{current_region}#${current_region}#g" ${CONF_PATH}/agentproxy.conf
    sed -i "s#{timezone}#${timezone}#g" ${CONF_PATH}/agentproxy.conf
    sed -i "s#{ip_version}#${ip_version}#g" ${CONF_PATH}/agentproxy.conf
    sed -i "s#{agentproxy_nodes}#${agentproxy_nodes}#g" ${CONF_PATH}/agentproxy.conf
    sed -i "s#{haproxy_float_ip}#${haproxy_float_ip}#g" ${CONF_PATH}/agentproxy.conf
    sed -i "s#{net_mask}#${net_mask}#g" ${CONF_PATH}/agentproxy.conf

    sed -i "s#{kms_endpoint}#${kms_endpoint}#g" ${CONF_PATH}/agentproxy.conf
    sed -i "s#{oc_address}#${oc_address}#g" ${CONF_PATH}/agentproxy.conf
    sed -i "s#{iam_address}#${iam_address}#g" ${CONF_PATH}/agentproxy.conf
}

config_proxy
log_info "config agentproxy cfg success."
