#!/bin/sh
CURRENT_PATH=$(dirname $(readlink -f $0))
LOG_TAG="proxy_install"
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
UTIL_CONF=${LINE_ROOT}/conf/util.conf
NODE_LIST=($(get_info.py agentproxy_nodes | sed 's/,/\ /g'))
LOCAL_IP=$(get_info.py manage_ip)
USER_NAME="dpamanager"
USER_HOME="/home/${USER_NAME}"
PRIVATE_KEY="${USER_HOME}/.ssh/id_rsa"
PUBLIC_KEY="${USER_HOME}/.ssh/id_rsa.pub"
AYTHORISED_FILE="${USER_HOME}/.ssh/authorized_keys"
SSH_OPT="-o StrictHostKeyChecking=no -o ConnectTimeout=5 -i ${USER_HOME}/.ssh/id_rsa"
# 关闭DNS加速
UseDNS=`grep "UseDNS " /etc/ssh/sshd_config`
if [[ "${UseDNS}" != "UseDNS no" ]]; then
    sed -i "s/${UseDNS}/UseDNS no/g" /etc/ssh/sshd_config
    service sshd restart>/dev/null
fi
# 设置主机监听地址
ListenAddress=`grep "^ListenAddress " /etc/ssh/sshd_config`
if [[ "${ListenAddress}" != "ListenAddress ${LOCAL_IP}" ]]; then
    sed -i "/${ListenAddress}/d" /etc/ssh/sshd_config
    echo "ListenAddress ${LOCAL_IP}" >> /etc/ssh/sshd_config
    service sshd restart>/dev/null
fi

pwd_en=$(get_pwd default_user_pwd ${UTIL_CONF})
export ENCRYPT_DATA=${pwd_en}
USER_PWD=$(proxython -c "import kmc.kmc;A=kmc.kmc.API();print(A.decrypt(0))")

function check_login()
{
    local host=$1
    local user=$2
    /usr/bin/expect<<-EOF
set timeout 5
spawn su - ${user}
expect {
        ":~>" {send "ssh $SSH_OPT ${user}@${host}\r"}
        "\$" {send "ssh $SSH_OPT ${user}@${host}\r"}
        }
expect {
        "yes/no" {exit 1}
        "assword:" { exit 2}
        ":~>" {exit 0}
        "\$" {exit 0}
        }
exit 3
EOF
}

function check_self_login()
{
    local host=$1
    local user=$2
    local passwd=$3
    check_password ${passwd}
    CHECK_RESULT $? "the passwd is invalid."
    /usr/bin/expect<<-EOF
set timeout 2
spawn su - ${user}
expect {
        ":~>" {send "ssh $SSH_OPT ${user}@${host}\r"}
        "\$" {send "ssh $SSH_OPT ${user}@${host}\r"}
        }
expect {
        "yes/no" { send "yes\r"; exp_continue}
        "assword:" { send "$passwd\r"}
        ":~>" {exit 0}
        "\$" {exit 0}
        }
expect {
        ":~>" {exit 0}
        "\$" {exit 0}
        "assword:" { exit 1}
        }
exit 3
EOF
}

function modify_auth_security()
{
    if [ -f /etc/pam.d/system-auth-local ];then
        if [ ! -f /etc/pam.d/system-auth.bak ];then
            cp -rf -P --remove-destination /etc/pam.d/system-auth-local /etc/pam.d/system-auth.bak
        fi
        sed -i "/auth        sufficient    pam_unix.so nullok try_first_pass/d" /etc/pam.d/system-auth-local
        sed -i "/password    required      pam_pwhistory.so use_authtok remember=5 enforce_for_root/d" /etc/pam.d/system-auth-local
    fi
    sed -i '/dpamanager/d' /etc/security/opasswd
}


function restore_auth_security()
{
    if [ -f /etc/pam.d/system-auth-local ];then
        if [ -f /etc/pam.d/system-auth.bak ];then
            rm -f /etc/pam.d/system-auth-local
            /usr/bin/cp -fP --remove-destination /etc/pam.d/system-auth.bak /etc/pam.d/system-auth-local
        fi
    fi
}

function unlock_user()
{
    local retry_time_limit=10
    local retry_time=0
    while [[ ${retry_time} -lt ${retry_time_limit} ]];do
        count=`pam_tally2 --reset -u ${USER_NAME} | grep ${USER_NAME} | awk '{print $2}'`
        if [[ ${count} -le 0 ]];then
             break
        fi
          retry_time=$[ ${retry_time} + 1 ]
          log_error "ulock user,retry_time:${retry_time}"
    done
}

function change_user_pwd()
{
    which chpasswd >/dev/null 2>&1
    if [[ $? -eq 0 ]];then
        echo "dpamanager:${pwd_de}" | chpasswd
        if [[ $? -ne 0 ]];then
            log_warn "chpasswd command failed, use passwd."
            echo ${USER_PWD} | passwd --stdin dpamanager
        fi
    else
        log_warn "chpasswd command not exist, use passwd."
        echo ${USER_PWD} | passwd --stdin dpamanager
    fi
    echo_info "change password of ${USER_NAME} success..."
}

function check_login_by_pwd()
{
    check_max_count=10
    check_count=0
    while [[ ${check_count} -lt ${check_max_count} ]];do
        check_self_login ${LOCAL_IP} ${USER_NAME} ${USER_PWD}
        if [[ $? -eq 0 ]];then
            break
        fi
        check_count=$[ ${check_count} + 1 ]
        log_error "check user,check_count:${check_count}"
        unlock_user
        sleep 1
    done
    chmod 600 ${USER_HOME}/.ssh/*
    echo_info "check user ${USER_NAME} login success..."
}

modify_auth_security
change_user_pwd
restore_auth_security
check_login_by_pwd
