# coding:utf-8
import os
import sys

from basesdk import utils

LOG = utils.get_logger("proxy_install")


def save_ini(c_file):
    ret = 0 if os.path.exists(c_file) else 1
    utils.check_result(ret, "Config file not exist", LOG)
    cmd = ['cp', '-f', c_file,
           '/opt/huawei-data-protection/sys.ini']
    ret, _ = utils.run_cmd(cmd)
    utils.check_result(ret, "Save config file failed", LOG)
    LOG.info("Save config file Successfully.")


def proxy_config(root):
    script = "%s/bin/osConfig/config_proxy.sh" % root
    ret, _ = utils.run_cmd(['sh', script])
    utils.check_result(ret, "Config agentproxy conf failed", LOG)
    LOG.info("Config agentproxy conf ok.")


def os_config(root):
    script = "%s/bin/osConfig/OSConfig.sh" % root
    ret, _ = utils.run_cmd(['sh', script])
    utils.check_result(ret, "Config os failed", LOG)
    LOG.info("Config os ok.")


if __name__ == '__main__':
    config_file = sys.argv[2]
    cur_dir = os.path.split(os.path.realpath(__file__))[0]
    root_dir = cur_dir.split("/bin")[0]
    print(".........Start to install agentproxy..........")
    LOG.info(".........Start to install agentproxy..........")
    save_ini(config_file)
    msg = "Successfully Check the configuration file."
    utils.print_and_judge_progress(5, True, msg)
    os_config(root_dir)
    proxy_config(root_dir)
    msg = "Successfully Config os and time."
    utils.print_and_judge_progress(10, True, msg)
