#!/bin/bash
ROOT_DIR=$(dirname $(readlink -f $0))
LOG_TAG="proxy_install"
USER_HOME="/home/dpamanager"
CONF_PATH="/opt/huawei-data-protection/agentproxy/conf"
source ${ROOT_DIR}/bin/utils.sh

function showhelp()
 {
    echo "Usage: ${ROOT_DIR}/install.sh -f [config file patch]"
    echo "Usage: ${ROOT_DIR}/install.sh -f restore"
}

function install_config()
{
    mkdir -p /opt/huawei-data-protection/agentproxy/{bin,certs,conf,data_bak,inspect,inst/bin,tmp,pkg/{agent,agent_assistant}}
    mkdir -p /opt/huawei-data-protection/agentproxy/tools/{agentproxy,cps-monitor,haproxy,omm-ha,zookeeper}

    /usr/bin/cp -f ${ROOT_DIR}/conf/agentproxy.conf ${CONF_PATH}
    /usr/bin/cp -f ${ROOT_DIR}/conf/rsyslog_proxy.conf ${CONF_PATH}
    /usr/bin/cp -f ${ROOT_DIR}/conf/version ${CONF_PATH}
    /usr/bin/cp -f ${ROOT_DIR}/bin/utils.sh /opt/huawei-data-protection/agentproxy/inst/bin
}

function install_log_files()
{
    if [ -d "/var/log/huawei-data-protection/agentproxy/services" ];then
        return 0
    fi
    mkdir -p /var/log/huawei-data-protection/agentproxy/services/{agentproxy,base,cps-monitor,haproxy,zookeeper,omm-ha}
    touch /var/log/huawei-data-protection/agentproxy/restserver.log
    touch /var/log/huawei-data-protection/agentproxy/services/agentproxy/agentproxy.log
    touch /var/log/huawei-data-protection/agentproxy/services/agentproxy/operation.log
    touch /var/log/huawei-data-protection/agentproxy/services/agentproxy/alarm.log
    touch /var/log/huawei-data-protection/agentproxy/services/agentproxy/logrotate.log
    touch /var/log/huawei-data-protection/agentproxy/services/base/basesdk.log
    touch /var/log/huawei-data-protection/agentproxy/services/base/kmc.log
    touch /var/log/huawei-data-protection/agentproxy/services/cps-monitor/ntp-monitor.log
    touch /var/log/huawei-data-protection/agentproxy/services/cps-monitor/alarm-monitor.log
    touch /var/log/huawei-data-protection/agentproxy/services/zookeeper/zookeeper.log
    touch /var/log/huawei-data-protection/agentproxy/services/zookeeper/v_zookeeperControl.log
    touch /var/log/huawei-data-protection/agentproxy/services/omm-ha/haArb.log
}

function install_proxython()
{
    rpm -ihv "${ROOT_DIR}"/repo/third_party/python-*.rpm --force --nodeps >/dev/null 2>&1
    rpm -ihv "${ROOT_DIR}"/repo/third_party/pip-*.rpm --force --nodeps >/dev/null 2>&1
    rm -rf /usr/lib/proxython/ensurepip/*
    proxython -m pip install --no-deps --force-reinstall "${ROOT_DIR}"/repo/self_developed/basesdk*.whl >/dev/null 2>&1
    /usr/bin/cp -f "${ROOT_DIR}"/bin/get_info.py /usr/bin/get_info.py
    chmod 550 /usr/bin/get_info.py
}

function change_files_permission()
{
    set_rw_permission /var/log/huawei-data-protection >/dev/null 2>&1
    local path=$(ls /usr/local/bin)
    for sub_dir in $path
    do
        if [ -d "/usr/local/bin/$sub_dir" ];then
            chmod 700 /usr/local/bin/$sub_dir
        else
            chmod 500 /usr/local/bin/$sub_dir
        fi
        set_common_permission  /usr/local/bin/$sub_dir
    done
    set_least_exec_permission /usr/local/bin/cps-monitor >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/cps-monitor/cps_mon.share >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/cps-monitor/kms_alarm.flag >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/ha/arbitrationtool/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/ha/ha/local >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/ha/ha/module/haarb/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/ha/ha/module/haarb/plugin >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/ha/ha/module/hacom/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/ha/ha/module/hacom/plugin/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/ha/ha/module/hamon/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/ha/ha/module/hamon/plugin/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/ha/ha/module/hasync/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/ha/ha/module/hasync/plugin/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/ha/ha/module/harm/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/ha/ha/module/harm/plugin/conf >/dev/null 2>&1
    set_least_exec_permission /usr/local/bin/ha/ha/module/harm/plugin/script >/dev/null 2>&1

    set_least_rw_permission /usr/local/bin/zookeeper/apache-zookeeper/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/zookeeper/data >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/zookeeper/logs >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/v_zookeeper/apache-zookeeper/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/v_zookeeper/data >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/v_zookeeper/logs >/dev/null 2>&1
    chown -hR agentproxy:agentproxy "${ROOT_DIR}"

    set_rw_permission /opt/huawei-data-protection/sys.ini
    set_least_permission `readlink /usr/lib/proxython` >/dev/null 2>&1

    chown -h agentproxy:agentproxy /usr/bin/get_info.py && chmod 550 /usr/bin/get_info.py
    chown -h root:agentproxy /opt/huawei-data-protection && chmod 750 /opt/huawei-data-protection
    set_root_exec_permission /opt/huawei-data-protection/root_tools
    set_least_exec_permission /opt/huawei-data-protection/agentproxy/inst
    set_least_exec_permission /opt/huawei-data-protection/agentproxy/pkg

    service sshd restart >/dev/null 2>&1
    return $?
}

function prevent_file_tamper()
{
    local path=$(ls $1)
    for file in $path
    do
        if [ -d $1"/"$file ]
        then
            prevent_file_tamper $1"/"$file
        else
            if [ -x $1"/"$file ]
            then
                chattr +i $1"/"$file
            fi
        fi
    done
}

if [ $# -lt 2 ] || [ $1 != "-f" ] || ! [ -f $2 ];
then
    showhelp
    exit 1
fi

if [ -f "/opt/huawei-data-protection/agentproxy/conf/version" ];
then
    echo "Service install failed, Do not support retry."
    exit 1
fi

install_config
if [[ $? -ne 0 ]];then
    echo "[ERROR] Install config failed..."
    exit 1
fi

install_log_files
if [[ $? -ne 0 ]];then
    echo "[ERROR] Install log files failed..."
    exit 1
fi

install_proxython
if [[ $? -ne 0 ]];then
    echo_error "Install service failed because install proxython failed..."
    exit 1
fi

dos2unix $2 >/dev/null 2>&1

proxython ${ROOT_DIR}/bin/pre_install.py -f $2
if [[ $? -ne 0 ]];then
    echo_error "Install service failed because exec pre_install files failed..."
    exit 1
fi

proxython ${ROOT_DIR}/bin/install_services.py "${ROOT_DIR}/services" --install $3
if [[ $? -ne 0 ]];then
    echo_error "Install service failed because install component failed..."
    exit 1
fi

systemctl restart haveged
change_files_permission
echo_info "Install service successfully..."
if [[ $# -ne 3 ]];then
    rm -rf ${ROOT_DIR}
fi
