#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u agentproxy bash $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) "$@";exit $?
elif [[ ${UID} -ne `get_info.py user_id operation_user` ]];then
    echo "Please switch to user(agentproxy) for run." && exit 1
fi
set +x
G_MAIN_PATH=/opt/huawei-data-protection/agentproxy

#******************************************************************#
# Function: show_middle_str
# Description: The function 
# Input Parameters:
# None
# Returns:
# exit code 0 means  function succeeds
#******************************************************************#
function show_middle_str ()
{
    local L_STRING="${1:-null}"
    local L_WIDTH="80"
    local L_STRING_W=""
    local L_BLANK_W=

    # length of string
    L_STRING_W=${#L_STRING}
    # numbers of blank before string
    L_BLANK_W=$(((${L_WIDTH}-${L_STRING_W})/2))

    for ((i=0; i<${L_BLANK_W}; i++)); do
        echo -n " "
    done
    echo -e "${L_STRING}"

}
#******************************************************************#
# Function: show_divison
# Description: Print specified symbol n times 
# Input Parameters:
# None
# Returns:
# exit code 0 means  function succeeds
#******************************************************************#
function show_division ()
{
    local L_SYMBOL="$1"
    local L_WIDTH="80"

    for ((i=0; i<${L_WIDTH}; i++)); do
        echo -n "${L_SYMBOL}"
    done

    echo
}
#******************************************************************#
# Function: show_basic_content
# Description: The function show info of the machine content 
# Input Parameters:
# None
# Returns:
# exit code 0 means  function succeeds
#******************************************************************#
function show_basic_content ()
{
    local L_SERIAL=""
    local L_DEVICE_NAME=`hostname`
    local PRODUCT_VERSION=`cat ${G_MAIN_PATH}/conf/version | grep "release_version" | awk -F'=' '{print $2}' | sed 's/ //g'`
    local L_DEVICE_MODEL="KarborProxy"
    local manage_ip=$(get_info.py manage_ip)
    L_SERIAL=`ip a | grep -B1 ${manage_ip} |grep ether | awk '{print $2}' | sed 's/:/-/g'`

    echo -e "        Product Name              |        ${L_DEVICE_NAME}"
    echo -e "        Device Model              |        ${L_DEVICE_MODEL}"
    echo -e "        Device Serial Number      |        ${L_SERIAL}"
    echo -e "        Product Version           |        ${PRODUCT_VERSION}"
}

function get_service_status()
{
    local status=`$1Control -CS CompontState`
 	  echo $status | awk -F ' ' '{print $NF}'
}

function show_services_content ()
{
    local cps_status=$(get_service_status "cps-monitor")
    local zk_status=$(get_service_status "zookeeper")
    local v_zk_status=$(get_service_status "v_zookeeper")
    local haproxy_status=$(get_service_status "haproxy")
    local omm_ha_status=$(get_service_status "omm-ha")
    local agentproxy_status=$(get_service_status "agentproxy")

    echo -e "        AgentProxy         |         ${agentproxy_status}"
    echo -e "        OMM-HA             |         ${omm_ha_status}"
    echo -e "        HAProxy            |         ${haproxy_status}"
    echo -e "        ZooKeeper          |         ${zk_status}"
    echo -e "        V_ZooKeeper        |         ${v_zk_status}"
    echo -e "        CPS-Monitor        |         ${cps_status}"
}

#******************************************************************#
# Function: show_basic_info
# Description: The function show info of the machine
# Input Parameters:
# None
# Returns:
# exit code 12 means EX_GENERAL_PARAMETER_NUM_ERROR
# exit code 0 means  function succeeds
#******************************************************************#
function show_basic_info ()  
{ 
    show_middle_str "System Information"
    show_division "-"
    show_basic_content
    show_division "-"
}

function show_service_info ()
{
    show_middle_str "Service Information"
    show_division "-"
    show_services_content
    show_division "-"
}
#******************************************************************# 
# Function:main
# Description: The function is a socket  
# Input Parameters: 
# 
# None
# Returns:
#
#******************************************************************#
function main ()
{
    if [ $# -eq 0 ]; then
        show_basic_info
    elif [ $# -eq 1 -a "$1" == "services" ]; then
        show_service_info
    else
        echo "param error."
        exit 1
    fi
    exit $?
}
##############################################################
# The main is starts here
main $*


