#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "${CURRENT_PATH}")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="proxy_install"

function switchover_ha()
{
    omm-haControl -CS CompontState | grep -q "active"
    if [[ $? -eq 0 ]];then
        log_info "begin switchover HA service."
        export LD_LIBRARY_PATH=/usr/local/bin/ha/ha/libs/ && /usr/local/bin/ha/ha/module/hacom/tools/ha_client_tool --switchover --name=product
        sleep 30s
        omm-haControl -CS CompontState | grep -q "standby"
        if [[ $? -ne 0 ]];then
            log_info "switchover HA service failed."
            exit 1
        fi
        log_info "switchover HA service success."
    fi
    return 0
}

switchover_ha
