#!/bin/bash
CURRENT_PATH=$(dirname "$(readlink -f "$0")")
LINE_ROOT=$(dirname "${CURRENT_PATH}")
ROOT_PATH=$(dirname "${LINE_ROOT}")
source "${LINE_ROOT}/bin/utils.sh"
export LOG_TAG="proxy_install"

function check_product_version()
{
    OLD_PRODUCT_VERSION=`cat /opt/huawei-data-protection/agentproxy/conf/version | grep "release_version" | awk -F'=' '{print $2}' | sed 's/ //g'`
    NEW_PRODUCT_VERSION=`cat ${LINE_ROOT}/conf/version | grep "release_version" | awk -F'=' '{print $2}' | sed 's/ //g'`
    if [[ ${NEW_PRODUCT_VERSION} == ${OLD_PRODUCT_VERSION} ]];then
        log_error "the new version is the same as the previous version and does not need to be upgraded."
        exit 1
    fi
}

function backup_old_version_data()
{
    log_info "begin upgrade backup service."
    if [[ -f "${ROOT_PATH}/old_version_data.tar.gz" ]];then
        rm -f "${ROOT_PATH}/old_version_data.tar.gz"
        rm -rf "${ROOT_PATH}/old_version_data"
    fi

    python_ver=`proxython -V | awk '{print $2}' | awk -F '.' '{printf("%s.%s", $1, $2)}'`
    sed -i s/3.8/${python_ver}/g `grep 3.8 -rl "${LINE_ROOT}/cfg/upgrade_files.conf"`
    run_tar_upgrade_files_cmd="tar -P -czf ${ROOT_PATH}/old_version_data.tar.gz $(cat "${LINE_ROOT}/cfg/upgrade_files.conf")"
    ${run_tar_upgrade_files_cmd}
    CHECK_RESULT "$?" "backup old_version_data failed."

    if [[ ! -d "${ROOT_PATH}/old_version_data" ]];then
        mkdir -p "${ROOT_PATH}/old_version_data"
    fi
    tar -xvf "${ROOT_PATH}/old_version_data.tar.gz" -C "${ROOT_PATH}/old_version_data" >/dev/null 2>&1
}

function uninstall_services()
{
    proxython ${LINE_ROOT}/bin/install_services.py "${LINE_ROOT}/services" --uninstall --for_upgrade
    CHECK_RESULT $? "uninstall agentproxy service failed"

    rm -rf /usr/bin/get_info.py
    rm -f /usr/bin/showsys
    rm -rf /etc/sudoers.d/{dpamanager,agentproxy}
    rm -rf /usr/local/bin/{ha,cps-monitor,zookeeper,jre}
    rm -rf /opt/huawei-data-protection
    log_info "uninstall service successfully."
}

function install_services()
{
    sh ${LINE_ROOT}/install.sh -f "${ROOT_PATH}/sys.ini" --for_upgrade
    service cron restart
    service sshd restart
    log_info "install service successfully --for upgrade."
}

function recover_file()
{
    ha_conf_path="/usr/local/bin"
    rm -rf /usr/local/bin/ha/*
    /usr/bin/cp -rf "${ROOT_PATH}/old_version_data${ha_conf_path}/ha" "${ha_conf_path}"
    chown -hR agentproxy:agentproxy /usr/local/bin/ha

    conf_root_path="/opt/huawei-data-protection/agentproxy/conf"
    old_conf_root_path="${ROOT_PATH}/old_version_data${conf_root_path}"
    /usr/bin/cp -f "${old_conf_root_path}/agentproxy.conf" "${conf_root_path}/agentproxy.conf"
    /usr/bin/cp -f "${old_conf_root_path}/zookeeper/zkClient.conf" "${conf_root_path}/zookeeper/zkClient.conf"
    /usr/bin/cp -f "${old_conf_root_path}/haproxy/privkey.conf" "${conf_root_path}/haproxy/privkey.conf"
    /usr/bin/cp -f "${old_conf_root_path}/omm-ha/privkey.conf" "${conf_root_path}/omm-ha/privkey.conf"
    /usr/bin/cp -rf "${old_conf_root_path}/kmc" "${conf_root_path}"

    cert_path="/opt/huawei-data-protection/agentproxy"
    /usr/bin/cp -rf "${ROOT_PATH}/old_version_data${cert_path}/certs" "${cert_path}"
    chown -hR agentproxy:agentproxy "${cert_path}/certs"

    cd ${ROOT_PATH}
    start_service cps-monitor
    start_service omm-ha
    start_service agentproxy
    log_info "recover all conf files success."
}

check_product_version
backup_old_version_data
uninstall_services
install_services
recover_file
sleep 15s
log_info "The upgrade of single node is complete."
