#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"
NODE_LIST=($(get_info.py agentproxy_nodes | sed 's/,/ /g'))
LOCAL_IP=$(get_info.py manage_ip)

set_crontab_task()
{
    sed -i '/data_backup.sh/d' /etc/crontab
    sed -i '/update_kmc_mk.py/d' /etc/crontab
    sed -i '/check_certificate_date.sh/d' /etc/crontab
    echo '59 23 * * * agentproxy /bin/bash /opt/huawei-data-protection/agentproxy/bin/backup/data_backup.sh' >> /etc/crontab
    echo '59 23 * * * agentproxy /bin/bash /opt/huawei-data-protection/agentproxy/bin/cert/check_certificate_date.sh' >> /etc/crontab
    if [[ "${LOCAL_IP}" == "${NODE_LIST[0]}" ]]; then
        echo '59 23 4 1 * agentproxy proxython /opt/huawei-data-protection/agentproxy/bin/update_kmc_mk.py' >> /etc/crontab
    fi
    service cron restart
}

function set_sudoers_for_ops()
{
    sed -i "/dpamanager/d" /etc/sudoers.d/agentproxy > /dev/null
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/opt/huawei-data-protection/agentproxy/bin/zk_operate.py" >> /etc/sudoers.d/agentproxy
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/opt/huawei-data-protection/agentproxy/bin/update_kmc_mk.py" >> /etc/sudoers.d/agentproxy
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/opt/huawei-data-protection/agentproxy/bin/switch_cipher_type.py" >> /etc/sudoers.d/agentproxy
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/opt/huawei-data-protection/agentproxy/bin/ops_config.py" >> /etc/sudoers.d/agentproxy
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/opt/huawei-data-protection/agentproxy/bin/cert_replace.py" >> /etc/sudoers.d/agentproxy

    echo "dpamanager ALL = (agentproxy) NOPASSWD:/usr/bin/agentproxyControl" >> /etc/sudoers.d/agentproxy
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/usr/bin/cps-monitorControl" >> /etc/sudoers.d/agentproxy
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/usr/bin/haproxyControl" >> /etc/sudoers.d/agentproxy
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/usr/bin/omm-haControl" >> /etc/sudoers.d/agentproxy
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/usr/bin/v_zookeeperControl" >> /etc/sudoers.d/agentproxy
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/usr/bin/zookeeperControl" >> /etc/sudoers.d/agentproxy
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/usr/bin/showsys" >> /etc/sudoers.d/agentproxy

    echo "dpamanager ALL = (agentproxy) NOPASSWD:/usr/bin/configZookeeper" >> /etc/sudoers.d/agentproxy
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/usr/bin/set_zk_client_password" >> /etc/sudoers.d/agentproxy
    echo "dpamanager ALL = (agentproxy) NOPASSWD:/usr/local/bin/ha/arbitrationtool/bin/configArb.py" >> /etc/sudoers.d/agentproxy
}

log_info "begin set crontab task..."
set_crontab_task
if [[ $? -ne 0 ]]; then
    echo_error "set crontab task falied......"
    exit 1
fi
log_info "set crontab task success..."

set_sudoers_for_ops
if [[ $? -ne 0 ]]; then
    echo_error "add sudo config for agentproxy failed......"
    exit 1
fi
log_info "set sudo config for agentproxy success..."