#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"
NODE_LIST=($(get_info.py agentproxy_nodes | sed 's/,/ /g'))
LOCAL_IP=$(get_info.py manage_ip)
RETRY_LIMIT=10

function check_remote_rpc_status()
{
    fail_count=0
    while [ ${fail_count} -lt ${RETRY_LIMIT} ]; do
        local is_alive=$(proxython -c "from basesdk import utils;print(utils.get_remote_rpc_status())")
        if [[ "${is_alive}" == "True" ]]; then
            log_info "Check remote rpc status success..."
            return 0
        fi
        let ++fail_count
        log_warn "Check remote rpc status failed, fail_count=${fail_count}..."
        sleep 30
    done
    echo_error "Check remote rpc status failed..."
    return 1
}

function set_random_pwd()
{
    random_pwd=$(mkpasswd -l 24 -s 0)
/usr/bin/expect<<-EOF
    set timeout 60
    spawn $1
    expect {
        "Please input a new password for zookeeper:" {send "${random_pwd}\r"}
    }
    expect {
        "Please input the new password again to confirm:" {send "${random_pwd}\r"}
    }
    expect {
        "Set password of zookeeper Successfully." {exit 0}
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

function update_kmc_mk()
{
    if [[ "${LOCAL_IP}" == "${NODE_LIST[0]}" ]]; then
        proxython /opt/huawei-data-protection/agentproxy/bin/update_kmc_mk.py
        return $?
    fi
    echo_info "This node do not need update kmc master key..."
}

function set_zookeeper_password()
{
    log_info "begin set zookeeper client password."
    if [[ "${LOCAL_IP}" == "${NODE_LIST[0]}" ]]; then
        set_random_pwd "set_zk_client_password"
        return $?
    else
        fail_count=0
        local server_ip=$(get_info.py ha_peer_node)
        while [ ${fail_count} -lt ${RETRY_LIMIT} ]; do
            local r_auth_data=$(proxython -c "import basesdk.rpc_client as c;c=c.get_client('${server_ip}');print(c.get_zk_client_pwd())")
            local l_auth_data=$(proxython -c "from basesdk import utils;print(utils.get_zk_info('zookeeper', 'authData'))")
            local auth_data_bak=$(proxython -c "from basesdk import utils;print(utils.get_zk_info('zookeeper', 'authDataBak'))")
            if [ "${r_auth_data}" == "${l_auth_data}" -a "${auth_data_bak}" != "None" ]; then
                return 0
            fi
            let ++fail_count
            echo_warn "Wait remote node set zookeeper client password failed, wait_time=${fail_count}..."
            sleep 15
        done
        return 1
    fi
}

function check_status()
{
    check_count=0
    while [ ${check_count} -lt 5 ]; do
        log_warn "agentproxy service is abnormal, wait 30s, wait_count=${check_count}......"
        sleep 30s
        agentproxyControl -CS CompontState | grep -q "running"
        if [[ $? -eq 0 ]]; then
            log_info "agentproxy service is normal."
            return 0
        fi
        let ++check_count
    done
    return 1
}

if [[ $# -ne 0 ]];then
    log_info "In upgrade scenarios, do not need to execute this file."
    exit 0
fi
check_remote_rpc_status
if [[ $? -ne 0 ]]; then
    echo_error "check remote rpc status failed..."
    exit 1
fi
log_info "check remote rpc status success..."
update_kmc_mk
if [[ $? -ne 0 ]]; then
    echo_error "update kmc master key failed..."
    exit 1
fi
log_info "update kmc master key success..."
set_zookeeper_password
if [[ $? -ne 0 ]]; then
    check_status
    CHECK_RESULT $? "set zookeeper client password failed..."
fi
log_info "set zookeeper client password success..."
