#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"
LOG_DIR="/var/log/huawei-data-protection/agentproxy/services/agentproxy"
SRC_DIR="/opt/huawei-data-protection/agentproxy/bin"
TOOL_DIR="/opt/huawei-data-protection/agentproxy/tools/agentproxy"

function stop_service()
{
    log_info "Begin to stop agentproxy..."
    if [[ ! -f /usr/bin/agentproxyControl ]];then
        log_warn "Stop agentproxy failed."
        return 0
    fi
    agentproxyControl -S STOP
    if [[ $? -ne 0 ]];then
        log_warn "Stop agentproxy failed."
        exit 1
    fi
    log_info "Stop agentproxy finished."
}

function uninstall_files()
{
    log_info "Remove links of agentproxy..."
    rm -f /usr/bin/agentproxyControl
    if [[ $# -eq 0 ]];then
        all_dir=(
            ${SRC_DIR}
            ${LOG_DIR}
            ${TOOL_DIR}
        )
    else
        all_dir=(
            ${SRC_DIR}
            ${TOOL_DIR}
        )
    fi
    for cur_dir in "${all_dir[@]}"
    do
        log_info "Remove directory ${cur_dir}..."
        rm -rf ${cur_dir}
        if [ $? -ne 0 ];then
            log_error "Remove directory ${cur_dir} failed."
            exit 1
        fi
    done

    sed -i '/data_backup.sh/d' /etc/crontab
    sed -i "/dpamanager/d" /etc/sudoers.d/agentproxy > /dev/null
}

function main()
{
    log_info "Begin to uninstall agentproxy..."
    stop_service
    uninstall_files $1
    log_info "Uninstall agentproxy successfully."
}

main $1
