#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"
LOG_DIR="/var/log/huawei-data-protection/agentproxy/services"
PYTHON_DIR="/usr/lib/python3.10"
PROXYTHON_DIR="/usr/lib/proxython"
JAVA_DIR="/usr/local/bin/jre"

function uninstall_files()
{
    log_info "Remove links of omm-ha..."
    rm -f /usr/bin/omm-haControl
    if [[ $# -eq 0 ]];then
        all_dir=(
            ${LOG_DIR}
            ${PYTHON_DIR}
            ${PROXYTHON_DIR}
            ${JAVA_DIR}
        )
    else
        all_dir=(
            ${PYTHON_DIR}
            ${PROXYTHON_DIR}
            ${JAVA_DIR}
        )
    fi
    for cur_dir in "${all_dir[@]}"
    do
        log_info "Remove directory ${cur_dir}..."
        rm -rf ${cur_dir}
        if [ $? -ne 0 ];then
            log_error "Remove directory ${cur_dir} failed."
        fi
    done
}

function main()
{
    log_info "Begin to uninstall base..."
    uninstall_files $1
    log_info "Uninstall base successfully."
}

main $1