#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u agentproxy bash $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) "$@";exit $?
elif [[ ${UID} -ne `get_info.py user_id operation_user` ]];then
    echo "Please switch to user(agentproxy) for run." && exit 1
fi

set +x
source /opt/huawei-data-protection/agentproxy/inst/bin/utils.sh
LOG_TAG="cps-monitorControl"
LOG_FILE="/var/log/huawei-data-protection/agentproxy/services/cps-monitor/cps-monitorControl.log"
CPS_MON_PATH="/usr/lib/proxython/site-packages/cps_monitor/cps_monitor.py"
component="cps-monitor"
ServiceState=

function stopHeartBeat()
{
    proxython /usr/lib/proxython/site-packages/cps_monitor/heartBeat.py STOP ${component}
    if [[ $? -ne 0 ]]; then
        echo_error "Unregister heartbeat of ${component} failed."
        exit 1
    fi
    log_info "Unregister heartbeat of ${component} success."
}

function startHeartBeat()
{
    proxython /usr/lib/proxython/site-packages/cps_monitor/heartBeat.py START ${component}
    if [[ $? -ne 0 ]]; then
        echo_error "Register heartbeat of ${component} failed."
        exit 1
    fi
    log_info "Register heartbeat of ${component} success."
}

function component_run()
{
    echo_info "Begin start ${component}."
    queryCmd=$(pgrep -f ${CPS_MON_PATH})
    if [[ "${queryCmd}" ]]; then
        echo "${component} is  running."
        return 0
    fi
    fail_count=0
    while [ ${fail_count} -lt 3 ]; do
        proxython ${CPS_MON_PATH} >/dev/null 2>>${LOG_FILE} &
        sleep 3
        queryCmd=$(pgrep -f ${CPS_MON_PATH})
        if [[ "${queryCmd}" ]]; then
            startHeartBeat
            echo_info "Start ${component} success."
            return 0
        fi
        let ++fail_count
        log_warn "Start ${component} failed, fail_count=${fail_count}."
        sleep 10
    done
    echo_error "Start ${component} failed."
    exit 1
}

function component_stop()
{
    echo_info "Begin stop ${component}."
    fail_count=0
    while [ ${fail_count} -lt 3 ]; do
        kill -9 $(pgrep -f ${CPS_MON_PATH}) >/dev/null 2>&1
        queryCmd=$(pgrep -f ${CPS_MON_PATH})
        if [[ -z "${queryCmd}" ]]; then
            stopHeartBeat
            echo_info "Stop ${component} success."
            return 0
        fi
        let ++fail_count
        log_warn "Stop ${component} failed, fail_count=${fail_count}."
        sleep 5
    done
    echo_error "Stop ${component} failed."
    exit 1
}


function component_status()
{
    queryCmd=$(pgrep -f ${CPS_MON_PATH})
    if [[ "${queryCmd}" ]]; then
        echo -e "\n cps_monitor is running\n"
        exit 0
    fi
    echo -e "\n cps_monitor was dead\n"
    exit 1
}

while true; do
    case "$1" in
        -S) ServiceState=$2;shift 2; break;;
        -A) Action=$2;shift 2; break;;
       -CS) CompStatus=$2;shift 2; break;;
        *) shift; break;;
    esac
done
if [ "RESTART" = "${Action}" ]; then
    component_stop
    component_run
elif [ "RUN" = "${ServiceState}" ]; then
    component_run
elif [ "STOP" = "${ServiceState}" ]; then
    component_stop
elif [ "CompontState" = "${CompStatus}" ]; then
    component_status
else
    show_cmd_help ${component}
fi
exit 0
