#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"
RUNTIME_ROOT_DIR=$(get_info.py runtime_root_dir)


function install_rpm()
{
    rpm -Uivh "${LINE_ROOT}"/repo/third_party/haproxy-*.rpm --force --nodeps
    CHECK_RESULT $? "install haproxy rpm failed."
    log_info "Finish haproxy uninstall configuration."
}

function set_non_local_bind()
{
    cat /etc/sysctl.conf | grep  'net.ipv4.ip_nonlocal_bind=1' > /dev/null 2>&1
    if [ $? -ne 0 ];then
        sed -i '/net.ipv4.ip_nonlocal_bind=*/d' /etc/sysctl.conf
        echo "net.ipv4.ip_nonlocal_bind=1"  >> /etc/sysctl.conf
        sysctl -p > /dev/null 2>&1
    fi
    log_info "set non_local ip bind success."
}

function install_tools()
{
    log_info "Init haproxy tools configuration."
    mkdir -p /opt/huawei-data-protection/agentproxy/tools/haproxy
    /usr/bin/cp -f "${CURRENT_PATH}"/tools/* /opt/huawei-data-protection/agentproxy/tools/haproxy
    CHECK_RESULT $? "Install haproxy tools Failed."
    create_link /opt/huawei-data-protection/agentproxy/tools/haproxy/haproxyControl.sh
    /usr/bin/cp -f "${CURRENT_PATH}"/conf/haproxy.conf /opt/huawei-data-protection/agentproxy/conf/haproxy
    CHECK_RESULT $? "Install haproxy tools Failed."
    log_info "Finsih haproxy tools configuration."
}

function config_haproxy()
{
    local haproxy_float_ip=$(get_info.py haproxy_float_ip)
    local haproxy_front_port=$(get_info.py haproxy_port)
    local agentproxy_nodes=($(get_info.py agentproxy_nodes | sed 's/,/ /g'))
    local backend_http_port=$(get_info.py agentproxy_http_port)
    local backend_tcp_port=$(get_info.py agentproxy_tcp_port)
    sed -i "s#{runtime_root_dir}#${RUNTIME_ROOT_DIR}#g" ${RUNTIME_ROOT_DIR}/conf/haproxy/haproxy.conf
    sed -i "s/{haproxy_float_ip}/${haproxy_float_ip}/g" ${RUNTIME_ROOT_DIR}/conf/haproxy/haproxy.conf
    sed -i "s/{haproxy_front_port}/${haproxy_front_port}/g" ${RUNTIME_ROOT_DIR}/conf/haproxy/haproxy.conf
    sed -i "s/{agentproxy_tcp_port}/${backend_tcp_port}/g" ${RUNTIME_ROOT_DIR}/conf/haproxy/haproxy.conf
    sed -i "s/{backend_http_port}/${backend_http_port}/g" ${RUNTIME_ROOT_DIR}/conf/haproxy/haproxy.conf
    sed -i "s/{backend_tcp_port}/${backend_tcp_port}/g" ${RUNTIME_ROOT_DIR}/conf/haproxy/haproxy.conf
    sed -i "s/{agentproxy_node1}/${agentproxy_nodes[0]}/g" ${RUNTIME_ROOT_DIR}/conf/haproxy/haproxy.conf
    sed -i "s/{agentproxy_node2}/${agentproxy_nodes[1]}/g" ${RUNTIME_ROOT_DIR}/conf/haproxy/haproxy.conf
}


log_info "Start haproxy installation."
install_rpm
CHECK_RESULT $? "install_zookeeper failed."
set_non_local_bind
CHECK_RESULT $? "install_zookeeper failed."
install_tools
CHECK_RESULT $? "install_zookeeper failed."
config_haproxy
CHECK_RESULT $? "install_zookeeper failed."
set_least_common_permission /opt/huawei-data-protection/agentproxy/inst/services/haproxy > /dev/null 2>&1
set_least_common_permission /opt/huawei-data-protection/agentproxy/tools/haproxy > /dev/null 2>&1
set_least_common_permission /opt/huawei-data-protection/agentproxy/conf/haproxy > /dev/null 2>&1
set_least_common_permission  /usr/sbin/haproxy* > /dev/null 2>&1
set_least_common_permission  /usr/share/man/man1/haproxy.1.gz
set_least_common_permission /usr/bin/proxython > /dev/null 2>&1
for file in $(find / -name "libpython3.10.so.1.0");do
    set_common_permission ${file}
done
log_info "Finish haproxy installation."