#!/bin/bash
if [ ${UID} -ne 0 ];then
  sudo $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) "$@";exit $?
fi

# 提供shell在root下校验ip能力
function check_ip()
{
    result=$(echo "$1" | xargs | awk -F. '$1<=255&&$2<=255&&$3<=255&&$4<=255{print "yes"}')
    if echo "$1" | grep -E "^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$">/dev/null; then
        if [[ ${result:-no} == "yes" ]]; then
            return 0
        fi
    fi
    return 1
}

function get_information()
{
    NET_LIST=`ls /sys/class/net`
    for NET in ${NET_LIST};do
        RET=`/sbin/ip addr show ${NET}|grep "$1" | wc -l`
        if [[ ${RET} -ne 0 ]];then
            INTERFACE=${NET}
        fi
    done
}

FLOAT_IP="$2"
NET_MASK="$3"
LOCAL_IP="$4"
INTERFACE=""
IP_PATTERN="^(([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])\.){3}([0-9]|[1-9][0-9]|1[0-9]{2}|2[0-4][0-9]|25[0-5])$"
MASK_PATTERN="^((128|192)|2(24|4[08]|5[245]))(\.(0|(128|192)|2((24)|(4[08])|(5[245])))){3}$"

# 从agentproxy用户获取节点网络使用前需要校验:预期IP格式
check_ip "${NET_MASK}"
[[ $? -ne 0 ]] && exit 1
check_ip "${FLOAT_IP}"
[[ $? -ne 0 ]] && exit 1
check_ip "${LOCAL_IP}"
[[ $? -ne 0 ]] && exit 1

if [[ ! ${FLOAT_IP} =~ ${IP_PATTERN} ]]; then
    exit 1
fi

if [[ "X${FLOAT_IP}" == "X0.0.0.0" ]] || [[ "X${FLOAT_IP}" == "X255.255.255.255" ]] || [[ "X${FLOAT_IP}" == "X127.0.0.1" ]];then
    exit 1
fi

if [[ ! ${NET_MASK} =~ ${MASK_PATTERN} ]]; then
    exit 1
fi

if [[ "$1" == "add" ]];then
    get_information ${LOCAL_IP}
    ip addr add ${FLOAT_IP}/${NET_MASK} dev ${INTERFACE} label ${INTERFACE}:"proxy" > /dev/null 2>&1
elif [[ "$1" == "del" ]];then
    get_information ${FLOAT_IP}
    ip addr del ${FLOAT_IP}/${NET_MASK} dev ${INTERFACE} > /dev/null 2>&1
else
    exit 1
fi