#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"
LOG_FILE="/var/log/huawei-data-protection/agentproxy/install.log"
HA_CONFIG_SH="/usr/local/bin/ha/ha/module/hacom/script/config_ha.sh"
export LD_LIBRARY_PATH=/usr/local/bin/ha/ha/libs/:${LD_LIBRARY_PATH}

function config_single_node()
{
    log_info "HA: begin to config single node omm-ha."
    bash ${HA_CONFIG_SH} -m single
    CHECK_RESULT $? "Error to config omm_ha in single node."
}

function judge_active_comp()
{
    local install_nodes=`get_info.py omm-ha_nodes`
    local active_mode=0
    local standby_mode=1
    local active_node=${install_nodes%%,*}
    if [[ "$1" == "${active_node}" ]];then
        echo ${active_mode}
    else
        echo ${standby_mode}
    fi
}


function config_peer_node()
{
    log_info "HA: begin to config peer node omm-ha."
    local local_ip=$(get_info.py manage_ip)
    local default_gateway=$(get_info.py default_gateway)
    case $(judge_active_comp ${local_ip}) in
    0) # active mode
        sh ${HA_CONFIG_SH} -m double -l ha1 -p ha2 -b ha1:${local_ip}:25555,ha2:$1:25555 -s ha1:${local_ip}:26666,ha2:$1:26666 -g ${default_gateway}  -j active >> ${LOG_FILE}
        CHECK_RESULT $? "Active add node failed."
    ;;
    1) # standby mode
        sh ${HA_CONFIG_SH} -m double -l ha2 -p ha1 -b ha2:${local_ip}:25555,ha1:$1:25555 -s ha2:${local_ip}:26666,ha1:$1:26666 -g ${default_gateway}  -j standby >> ${LOG_FILE}
        CHECK_RESULT $? "Standby add node failed."
    ;;
    *)
        log_error "The mode get form host error."
        exit 1
    ;;
    esac
}

function get_encrypted_pwd()
{
    local cipher_mode=0
    if [[ "`get_info.py cipher_type`" != "generalCipher" ]];then
        cipher_mode=1
    fi
    export ENCRYPT_DATA=$(cat /opt/huawei-data-protection/agentproxy/conf/omm-ha/privkey.conf | awk '{print $2}')
    pas2wd=$(proxython -c "import kmc.kmc;A=kmc.kmc.API();print(A.decrypt(0))")
    unset ENCRYPT_DATA
    G_HA_KEYTOOL="/usr/local/bin/ha/ha/module/hacom/tools/key-tool"
    /usr/bin/expect<<-EOF
    set timeout 60
    spawn ${G_HA_KEYTOOL} -a ${cipher_mode} -i
    expect {
        "Please input password:" {send "${pas2wd}\r"}
    }
    expect {
        "Please input password:" {exit 1}
    }
    lassign [wait] pid spawnid os_error_flag value
    exit \$value
EOF
}

function config_openssl()
{
    G_HA_CERT_DESTINATION="/usr/local/bin/ha/ha/local/cert"
    pushd ${G_HA_CERT_DESTINATION} >/dev/null
    rm -f ${G_HA_CERT_DESTINATION}/server.key
    get_encrypted_pwd | grep "Encrypted" | awk -F: '{print $NF}' | tr -d ' ' > ${G_HA_CERT_DESTINATION}/server.key
    HA_CERT_PATH="/opt/huawei-data-protection/agentproxy/certs/omm-ha"
    /usr/bin/cp -f ${HA_CERT_PATH}/ha_key.pem ${G_HA_CERT_DESTINATION}/server.pem
    /usr/bin/cp -f ${HA_CERT_PATH}/ha_cert.pem ${G_HA_CERT_DESTINATION}/server.crt
    /usr/bin/cp -f ${HA_CERT_PATH}/ha_ca-cert.pem ${G_HA_CERT_DESTINATION}/cacert.pem
    set_least_common_permission ${G_HA_CERT_DESTINATION}
    popd >/dev/null
    local l_keypass=`cat ${G_HA_CERT_DESTINATION}/server.key`
    echo "${l_keypass}" | bash /usr/local/bin/ha/ha/module/hacom/script/config_ha.sh -q false -S ssl=true,twoway=true,rootca=${G_HA_CERT_DESTINATION}/cacert.pem,keypass= > /dev/null
    CHECK_RESULT $?  "config openssl failed,Please Contact Huawei technical support."
}

function config_omm_ha()
{
    local ha_peer_node=`get_info.py ha_peer_node`
    if [[ "${ha_peer_node}" != "None" ]];then
        config_peer_node "${ha_peer_node}"
    else
        config_single_node
    fi
}

config_omm_ha
config_openssl
echo_info "Config omm-ha successfully......"