#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"
IP_VERSION=`proxython /usr/bin/get_info.py --ip_version`
HA_INSTALL_PATH="/usr/local/bin/ha"
TOOL_PATH="/opt/huawei-data-protection/agentproxy/tools/omm-ha"
SUDO_PATH="/opt/huawei-data-protection/root_tools/omm-ha"
HA_PLUGIN_PATH="/usr/local/bin/ha/ha/module/harm/plugin"
LOG_PATH="/var/log/huawei-data-protection"

function install_tools()
{
    log_info "Init omm-ha tools configuration."
    mkdir -p ${TOOL_PATH}
    /usr/bin/cp -f "${CURRENT_PATH}"/tools/* ${TOOL_PATH}
    create_link ${TOOL_PATH}/omm-haControl.sh
    chown -hR agentproxy:agentproxy ${TOOL_PATH}
    chmod 550 ${TOOL_PATH}/*.sh
    log_info "Finsih omm-ha tools configuration."
}

function config_files()
{
    var_log="/var/log"
    ebk_log="/opt/huawei-data-protection/ebackup/logs"
    agentproxy_log="$var_log/huawei-data-protection"
    ha_log="${agentproxy_log}/ha/scriptlog"
    ha_conf="$1/module/hacom/conf/hacom.xml"
    habin_start="$1/module/hacom/script/functions/start_habin.sh"
    habin_status="$1/module/hacom/script/functions/status_habin.sh"
    ha_status="$1/module/hacom/script/status_ha.sh"
    ha_monitor="$1/module/hamon/script/start_ha_monitor.sh"

    sed -i "s:false:true:g" ${ha_conf}
    sed -i "s:$var_log:$agentproxy_log:g" ${ha_conf}
    sed -i "s:$ebk_log:$ha_log:g" ${habin_status}
    sed -i "s:$ebk_log:$ha_log:g" ${ha_status}
    sed -i '/LD_LIBRARY_PATH/d' ${ha_status}
    sed -i '/hcpprocess:hcp/d' ${habin_status}
    sed -i '/hcpprocess:hcp/d' ${habin_start}
    sed -i '/hcpprocess:hcp/d' ${ha_monitor}
    [[ ${IP_VERSION} != "ipv6" ]] && sed -i "s/::1/127.0.0.1/g" ${ha_conf}
}

function install_omm_ha()
{
    tar axvf "${LINE_ROOT}"/repo/platform/omm-ha/HA*.tar.gz -C "${CURRENT_PATH}">> /dev/null
    config_files "${CURRENT_PATH}/HA*/software"
    rm -rf ${HA_INSTALL_PATH} && mkdir ${HA_INSTALL_PATH} -p
    bash "${CURRENT_PATH}"/HA*/install.sh -p ${HA_INSTALL_PATH}

    /usr/bin/cp "${CURRENT_PATH}"/arb/* ${HA_INSTALL_PATH}/ -rfp
    set_least_common_permission ${HA_INSTALL_PATH}
    log_info "Install HA*.tar.gz finish."

    /usr/bin/cp "${CURRENT_PATH}"/conf/hasync_mod.xml ${HA_INSTALL_PATH}/ha/module/hasync/plugin/conf/
    set_least_common_permission ${HA_INSTALL_PATH}
    log_info "install omm-ha finish."
}

function config_floatip()
{
    mkdir -p ${HA_PLUGIN_PATH}/{conf,script}
    chmod -R 750 ${HA_PLUGIN_PATH}
    /usr/bin/cp -f "${CURRENT_PATH}"/script/*.xml ${HA_PLUGIN_PATH}/conf
    /usr/bin/cp -f "${CURRENT_PATH}"/script/*.sh ${HA_PLUGIN_PATH}/script
    chown -hR agentproxy:agentproxy ${HA_PLUGIN_PATH}/{conf,script}
    set_least_exec_permission ${HA_PLUGIN_PATH}/script
    set_least_rw_permission ${HA_PLUGIN_PATH}/conf

    mkdir -p ${SUDO_PATH}
    /usr/bin/cp -f "${CURRENT_PATH}"/conf/update_ip.sh ${SUDO_PATH}
}

function config_ha_logs()
{
    if [[ ! -d "${LOG_PATH}/ha" ]]; then
      mkdir -p ${LOG_PATH}/ha
      chown -hR agentproxy:agentproxy ${LOG_PATH}/ha
    fi
}

function set_least_permissions()
{
    set_least_rw_permission ${HA_INSTALL_PATH}/arbitrationtool/conf >/dev/null 2>&1
    set_least_rw_permission ${HA_INSTALL_PATH}/ha/local >/dev/null 2>&1
    set_least_rw_permission ${HA_INSTALL_PATH}/ha/module/haarb/conf >/dev/null 2>&1
    set_least_rw_permission ${HA_INSTALL_PATH}/ha/module/haarb/plugin >/dev/null 2>&1
    set_least_rw_permission ${HA_INSTALL_PATH}/ha/module/hacom/conf >/dev/null 2>&1
    set_least_rw_permission ${HA_INSTALL_PATH}/ha/module/hacom/plugin/conf >/dev/null 2>&1
    set_least_rw_permission ${HA_INSTALL_PATH}/ha/module/hamon/conf >/dev/null 2>&1
    set_least_rw_permission ${HA_INSTALL_PATH}/ha/module/hamon/plugin/conf >/dev/null 2>&1
    set_least_rw_permission ${HA_INSTALL_PATH}/ha/module/hasync/conf >/dev/null 2>&1
    set_least_rw_permission ${HA_INSTALL_PATH}/ha/module/hasync/plugin/conf >/dev/null 2>&1
    set_least_rw_permission ${HA_INSTALL_PATH}/ha/module/harm/conf >/dev/null 2>&1
    set_least_rw_permission ${HA_INSTALL_PATH}/ha/module/harm/plugin/conf >/dev/null 2>&1
    set_least_exec_permission ${HA_INSTALL_PATH}/ha/module/harm/plugin/script >/dev/null 2>&1
}

function set_sudoers_for_omm_ha()
{
    sed -i "/\/update_ip.sh/d" /etc/sudoers.d/agentproxy > /dev/null
    echo "%agentproxy ALL = (root) NOPASSWD:${SUDO_PATH}/update_ip.sh" >> /etc/sudoers.d/agentproxy
}

log_info "Begin to install omm-ha..."
install_tools
CHECK_RESULT $? "Install omm-ha: install tools failed..."
install_omm_ha
CHECK_RESULT $? "Install omm-ha: install failed..."
config_ha_logs
config_floatip
CHECK_RESULT $? "Install omm-ha: config floatIp failed..."
set_least_permissions
set_sudoers_for_omm_ha
CHECK_RESULT $? "Install omm-ha: set sudoers failed..."
log_info "Install omm-ha finished."