#!/bin/bash
source /opt/huawei-data-protection/agentproxy/inst/bin/utils.sh
export LD_LIBRARY_PATH=/usr/local/bin/ha/ha/libs/:${LD_LIBRARY_PATH}
ZOO_CFG="/usr/local/bin/zookeeper/apache-zookeeper/conf/zoo.cfg"
V_ZOO_CFG="/usr/local/bin/v_zookeeper/apache-zookeeper/conf/zoo.cfg"
FLOAT_IP=$(get_info.py haproxy_float_ip)
MANAGE_IP=$(get_info.py manage_ip)
NET_MASK=$(get_info.py net_mask)
VZK_DATA_PORT=$(get_info.py v_zookeeper_data_port)
VZK_ELECTION_PORT=$(get_info.py v_zookeeper_election_port)
LOG_TAG="omm-haControl"

function set_floatip()
{
    ip addr | grep "\ ${FLOAT_IP}/" | grep -v grep >> /dev/null 2>&1
    if [ $? -eq 0 ];then
      log_info "${FLOAT_IP} is already set..."
        return 0
    fi
    sudo /opt/huawei-data-protection/root_tools/omm-ha/update_ip.sh add ${FLOAT_IP} ${NET_MASK} ${MANAGE_IP}
    if [[ $? -ne 0 ]];then
        log_error "set ${FLOAT_IP} failed..."
        return 1
    fi
    log_info "set ${FLOAT_IP} success..."
}

function unset_floatip()
{
    ip addr | grep "\ ${FLOAT_IP}/" | grep -v grep >> /dev/null 2>&1
    if [ $? -ne 0 ];then
        log_warn "${FLOAT_IP} has been unset..."
        return 0
    fi
    sudo /opt/huawei-data-protection/root_tools/omm-ha/update_ip.sh del ${FLOAT_IP} ${NET_MASK} ${MANAGE_IP}
    if [ $? -ne 0 ];then
        log_info "unset ${FLOAT_IP} falied..."
        return 1
    fi
    log_info "unset ${FLOAT_IP} success..."
}

function start_virtual_zookeeper()
{
    log_info "begin restart virtual zookeeper..."
    sed -i '/server.3/ d ' ${ZOO_CFG}
    echo "server.3=${MANAGE_IP}:${VZK_DATA_PORT}:${VZK_ELECTION_PORT}" >> ${ZOO_CFG}
    sed -i '/server.3/ d ' ${V_ZOO_CFG}
    echo "server.3=${MANAGE_IP}:${VZK_DATA_PORT}:${VZK_ELECTION_PORT}" >> ${V_ZOO_CFG}

    zookeeperControl -A RESTART
    if [ $? -ne 0 ];then
        log_error "restart zookeeper failed..."
        return 1
    fi
    log_info "restart zookeeper success..."
    v_zookeeperControl -A RESTART
    if [ $? -ne 0 ];then
        log_error "restart virtual zookeeper failed..."
        return 1
    fi
    log_info "restart virtual zookeeper success..."
}

function stop_virtual_zookeeper()
{
    log_info "begin stop virtual zookeeper..."
    v_zookeeperControl -S STOP
    if [ $? -ne 0 ];then
        log_error "stop virtual zookeeper failed..."
        return 1
    fi
    log_info "stop virtual zookeeper success..."

    sed -i '/server.3/ d ' ${ZOO_CFG}
    local zk_nodes=($(get_info.py zookeeper_nodes | sed 's/,/ /g'))
    if [[ "${zk_nodes[0]}" == "${MANAGE_IP}" ]];then
        echo "server.3=${zk_nodes[1]}:${VZK_DATA_PORT}:${VZK_ELECTION_PORT}" >> ${ZOO_CFG}
    else
        echo "server.3=${zk_nodes[0]}:${VZK_DATA_PORT}:${VZK_ELECTION_PORT}" >> ${ZOO_CFG}
    fi

    zookeeperControl -A RESTART
    if [ $? -ne 0 ];then
        log_error "restart zookeeper failed..."
        return 1
    fi
    log_info "restart zookeeper success..."
}

function get_floatip_info()
{
    ip addr | grep "\ ${FLOAT_IP}/" | grep -v grep >> /dev/null 2>&1
    if [ $? -ne 0 ];then
        log_warn "get float ip failed..."
        return 2
    fi
    log_info "get float ip success..."
}


#******************************************************************#
# Function: main
# Description: main
# Input Parameters:action
# Return : 0 double mode 
#exit code:
# single / active-active
#   0 = normal
#   1 = abnormal
#   2 = stop
#   3 = unknown
#   4 = starting
#   5 = stopping
#   10 = invaild action
#
# active-standby
#   1 = abnormal
#   2 = stop
#   3 = unknown
#   6 = active normal
#   7 = standby normal
#   8 = switching to active
#   9 = switching to standby
#   10 = invaild action
#******************************************************************#
function main ()
{
    case $1 in
    status)
        get_floatip_info
        exit $?
        ;;
    start)
        set_floatip
        if [ $? -ne 0 ];then
            exit 1
        fi
        start_virtual_zookeeper
        exit $?
        ;;
    stop)
        unset_floatip
        if [ $? -ne 0 ];then
            exit 1
        fi
        stop_virtual_zookeeper
        exit $?
        ;;
    force-stop)
        unset_floatip
        if [ $? -ne 0 ];then
            exit 1
        fi
        stop_virtual_zookeeper
        exit $?
        ;;
    *)
        exit 10
        ;;
    esac
}
main "$@"
