#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u agentproxy bash $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) "$@";exit $?
elif [[ ${UID} -ne `get_info.py user_id operation_user` ]];then
    echo "Please switch to user(agentproxy) for run." && exit 1
fi

set +x
source /opt/huawei-data-protection/agentproxy/inst/bin/utils.sh
HA_LOG_PATH="/var/log/huawei-data-protection/ha"
HA_INSTALL_PATH="/usr/local/bin/ha"
export LD_LIBRARY_PATH=/usr/local/bin/ha/ha/libs/:${LD_LIBRARY_PATH}
ServiceState=""
component="omm-ha"
LOG_TAG="omm-haControl"
LOG_FILE="/var/log/huawei-data-protection/agentproxy/services/omm-ha/omm-haControl.log"

function component_run()
{
    echo_info "Begin start ${component}."
    bash /usr/local/bin/ha/ha/module/hamon/script/start_ha_monitor.sh >/dev/null 2>>${LOG_FILE} &
    if [[ $? -ne 0 ]]; then
        echo_error "Start ${component} failed."
        exit 1
    fi
    startHeartBeat
    if [[ $? -ne 0 ]]; then
        echo_error "Start ${component} failed."
        exit 1
    fi
    echo_info "Start ${component} success."
}

function component_stop()
{
    echo_info "Begin stop ${component}."
    bash /usr/local/bin/ha/ha/module/hamon/script/stop_ha_monitor.sh >> /dev/null 2>&1
    ps -ef | grep ha | grep module | grep ha_monitor | grep -v grep | awk '{print $2}' | xargs kill -9 >> /dev/null 2>&1
    bash /usr/local/bin/ha/ha/module/hacom/script/stop_ha.sh >/dev/null 2>>${LOG_FILE} &
    ps -ef | grep ha | grep module | grep ha.bin | grep -v grep | awk '{print $2}'| xargs kill -9 >> /dev/null 2>&1
    stopHeartBeat
    if [[ $? -ne 0 ]]; then
        echo_error "Stop ${component} failed."
        exit 1
    fi
    echo_info "Stop ${component} success."
}

function component_restart()
{
    component_stop
    component_run
}

function component_status()
{
    queryCmd=`ps -eo pid,cmd ww | grep 'ha_monitor'| grep 'module' | grep -v grep| awk '{print $1}'`
    if [ -z "${queryCmd}" ]; then
        echo "omm-ha was dead"
        exit 1
    fi
    local status_info=$(bash /usr/local/bin/ha/ha/module/hacom/script/get_harole.sh)
    if [[ "${status_info}X" == "activeX" ]];then
        local ha_nodes=($(get_info.py omm-ha_nodes|sed 's/,/ /g'))
        if [[ "${#ha_nodes[@]}" == "1" ]];then
            echo -e "\nHA role: single\n"
            exit 0
        fi
        echo -e "\nHA role: active\n"
        exit 2
    fi
    if [[ "${status_info}X" == "standbyX" ]];then
        echo -e "\nHA role: standby\n"
        exit 3
    fi
    echo -e "\nHA role: unknown\n"
    exit 1
}

function stopHeartBeat()
{
    proxython /usr/lib/proxython/site-packages/cps_monitor/heartBeat.py STOP ${component}
    if [[ $? -ne 0 ]]; then
        log_error "Unregister heartbeat of ${component} failed."
        return 1
    fi
    log_info "Unregister heartbeat of ${component} success."
}

function startHeartBeat()
{
    proxython /usr/lib/proxython/site-packages/cps_monitor/heartBeat.py START ${component}
    if [[ $? -ne 0 ]]; then
        log_error "Register heartbeat of ${component} failed."
        return 1
    fi
    log_info "Register heartbeat of ${component} success."
}

cd /opt/huawei-data-protection/agentproxy/tools/omm-ha
while true; do
    case "$1" in
        -S) ServiceState=$2;shift 2; break;;
        -CS) CompStatus=$2;shift 2; break;;
        -A) Action=$2;shift 2; break;;
        *) shift; break;;
    esac
done
if [ "RESTART" = "${Action}" ]; then
    (
        component_restart
    )
elif [ "RUN" = "${ServiceState}" ]; then
    (
        component_run
    )
elif [ "STOP" = "${ServiceState}" ]; then
    (
        component_stop
    )
elif [ "CompontState" = "${CompStatus}" ]; then
    (
        component_status
    )
    exit $?
else
    show_cmd_help ${component}
fi
exit $?
