#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
LOG_TAG="proxy_install"
LOG_DIR="/var/log/huawei-data-protection/agentproxy/services/ha"
TOOL_DIR="/opt/huawei-data-protection/agentproxy/tools/omm-ha"
SRC_DIR="/usr/local/bin/ha"

function stop_service()
{
    omm-haControl -S STOP >/dev/null 2>&1
    rm -rf /usr/local/bin/ha
    rm -f /usr/bin/omm-haControl
    for so_file in $(ls -l  /usr/lib64/ | grep site-packages/kmc | awk -F ' ' '{print $9}')
    do
        rm -f /usr/lib64/${so_file}
    done
}

function uninstall_files()
{
    log_info "Remove links of omm-ha..."
    rm -f /usr/bin/omm-haControl
    if [[ $# -eq 0 ]];then
        all_dir=(
            ${LOG_DIR}
            ${TOOL_DIR}
            ${SRC_DIR}
        )
    else
        all_dir=(
            ${TOOL_DIR}
            ${SRC_DIR}
        )
    fi
    for cur_dir in "${all_dir[@]}"
    do
        log_info "Remove directory ${cur_dir}..."
        rm -rf ${cur_dir}
        if [ $? -ne 0 ];then
            log_error "Remove directory ${cur_dir} failed."
        fi
    done
    sed -i "/\/update_ip.sh/d" /etc/sudoers.d/agentproxy > /dev/null
}

function main()
{
    log_info "Begin to uninstall omm-ha..."
    stop_service
    uninstall_files $1
    log_info "Uninstall omm-ha successfully."
}

main $1