#!/bin/bash
CURRENT_PATH=$(dirname $(readlink -f $0))
LOG_TAG="proxy_install"
LINE_ROOT=$(dirname $(dirname ${CURRENT_PATH}))
source ${LINE_ROOT}/bin/utils.sh
SERVICE_PATH="/opt/huawei-data-protection/agentproxy/services"
ZK_PATH="/usr/local/bin/zookeeper"
V_ZK_PATH="/usr/local/bin/v_zookeeper"
TOOL_PATH="/opt/huawei-data-protection/agentproxy/tools/zookeeper"
DATA_DIR=${ZK_PATH}/data
DATA_LOG_DIR=${ZK_PATH}/logs
SYS_LOG_DIR="/var/log/huawei-data-protection/agentproxy/services/zookeeper"
ZK_CONF_PATH="/opt/huawei-data-protection/agentproxy/conf/zookeeper"
ZOO_CFG=${ZK_PATH}/apache-zookeeper/conf/zoo.cfg
V_ZOO_CFG=${V_ZK_PATH}/apache-zookeeper/conf/zoo.cfg
MANAGE_IP=$(get_info.py manage_ip)

function install_conf()
{
    /usr/bin/cp -f "${LINE_ROOT}"/repo/self_developed/zookeeper-auth.jar "${CURRENT_PATH}"/conf

    /usr/bin/cp -f "${CURRENT_PATH}"/conf/checkState.sh ${ZK_PATH}/apache-zookeeper/bin/checkState.sh
    /usr/bin/cp -f "${CURRENT_PATH}"/conf/*.jar ${ZK_PATH}/apache-zookeeper/lib/
    /usr/bin/cp -f "${CURRENT_PATH}"/conf/log4j.properties ${ZK_PATH}/apache-zookeeper/conf/
    /usr/bin/cp -f "${CURRENT_PATH}"/conf/java.env ${ZK_PATH}/apache-zookeeper/conf/
    /usr/bin/cp -f "${CURRENT_PATH}"/conf/zkClient.conf ${ZK_CONF_PATH}
    set_least_rw_permission ${ZK_CONF_PATH}
}

function install_zookeeper()
{
    mkdir -p ${ZK_PATH}
    tar -zxvf "${LINE_ROOT}"/repo/platform/zookeeper/apache-zookeeper*.tar.gz -C ${ZK_PATH} >/dev/null 2>&1
    if [[ $? -ne 0 ]]; then
        echo "install zookeeper failed,quit."
        exit 1
    fi
    mv ${ZK_PATH}/apache-zookeeper* ${ZK_PATH}/apache-zookeeper
    rm -rf ${ZK_PATH}/apache-zookeeper/docs
    rm -rf ${ZK_PATH}/apache-zookeeper/README_packaging.md
    rm -rf ${ZK_PATH}/apache-zookeeper/README.md

    install_conf
    CHECK_RESULT $? "Copy zookeeper config file to ${ZK_PATH}/apache-zookeeper failed."
    mkdir -p ${TOOL_PATH}
    /usr/bin/cp -f "${CURRENT_PATH}"/tools/zookeeperControl.sh ${TOOL_PATH}
    /usr/bin/cp -f "${CURRENT_PATH}"/tools/configZookeeper.sh ${TOOL_PATH}
    set_least_common_permission ${TOOL_PATH}
    create_link ${TOOL_PATH}/zookeeperControl.sh
    create_link ${TOOL_PATH}/configZookeeper.sh
}

function _redirect_zoo_log()
{
    # 更改ZKserver中的日志定向规则
    sed -i '/zookeeper.log.dir=/ d' $1/apache-zookeeper/conf/log4j.properties
    sed -i "21a zookeeper.log.dir=$2" $1/apache-zookeeper/conf/log4j.properties
    sed -i "s/.out/.log/" $1/apache-zookeeper/bin/zkServer.sh
    sed -i "28a ZOO_LOG_DIR=${SYS_LOG_DIR}" ${ZK_PATH}/apache-zookeeper/bin/zkEnv.sh
}

function _modify_zoo_cfg()
{
    sed -i '/initLimit/ d ' ${ZOO_CFG}
    echo "initLimit=20" >> ${ZOO_CFG}
    sed -i '/syncLimit/ d ' ${ZOO_CFG}
    echo "syncLimit=10" >> ${ZOO_CFG}
    sed -i '/tickTime/ d ' ${ZOO_CFG}
    echo "tickTime=4000" >> ${ZOO_CFG}

    sed -i '/maxClientCnxns/ d ' ${ZOO_CFG}
    echo "maxClientCnxns=300" >> ${ZOO_CFG}

    sed -i '/autopurge.snapRetainCount/ d ' ${ZOO_CFG}
    sed -i '/autopurge.purgeInterval/ d ' ${ZOO_CFG}
    echo "autopurge.snapRetainCount=10" >> ${ZOO_CFG}
    echo "autopurge.purgeInterval=1" >> ${ZOO_CFG}

    sed -i '/dataLogDir/ d ' ${ZOO_CFG}
    echo "dataLogDir=${ZK_PATH}/logs" >> ${ZOO_CFG}

    sed -i '/dataDir=/ d ' ${ZOO_CFG}
    echo "dataDir=${ZK_PATH}/data" >> ${ZOO_CFG}
}

function _modify_zoo_server()
{
    local zk_nodes=($(get_info.py zookeeper_nodes | sed 's/,/ /g'))
    local float_ip=$(get_info.py haproxy_float_ip)
    local zookeeper_data_port=$(get_info.py zookeeper_data_port)
    local zookeeper_election_port=$(get_info.py zookeeper_election_port)
    local zookeeper_client_port=$(get_info.py zookeeper_client_port)
    local vzk_data_port=$(get_info.py v_zookeeper_data_port)
    local vzk_election_port=$(get_info.py v_zookeeper_election_port)

    sed -i '/clientPort/ d ' ${ZOO_CFG}
    echo "clientPort=${zookeeper_client_port}" >> ${ZOO_CFG}
    sed -i '/clientPortAddress/ d ' ${ZOO_CFG}
    echo "clientPortAddress=${MANAGE_IP}" >> ${ZOO_CFG}

    for ((i=0;i<${#zk_nodes[@]};i++));do
        echo "server.$[i+1]=${zk_nodes[i]}:${zookeeper_data_port}:${zookeeper_election_port}" >> ${ZOO_CFG}
        if [[ "${MANAGE_IP}" == "${zk_nodes[i]}" ]];then
            echo "$[i+1]" > ${DATA_DIR}/myid
            CHECK_RESULT $? "set myid for zookeeper_$[i+1] failed..."
        fi
    done
    echo "server.3=${zk_nodes[0]}:${vzk_data_port}:${vzk_election_port}" >> ${ZOO_CFG}
}

function _modify_JMXDISABLE()
{
    local zkServer_sh="${ZK_PATH}/apache-zookeeper/bin/zkServer.sh"
    sed -i '/"x$JMXDISABLE"/ i JMXDISABLE=true' "${zkServer_sh}"
    # disable jettty
    local orgin_text="\"-Dzookeeper.root.logger=\${ZOO_LOG4J_PROP}\""
    local new_text="\"-Dzookeeper.root.logger=\${ZOO_LOG4J_PROP}\" \"-Dzookeeper.admin.enableServer=false\""
    sed -i "s/${orgin_text}/${new_text}/g" "${zkServer_sh}"
}

function _enhance_auth()
{
    local conf_dir=${ZK_PATH}/apache-zookeeper/conf
    local authfile="${ZK_CONF_PATH}/zkClient.conf"
    sed -i '/authProvider.1/d ' "${ZOO_CFG}"
    echo "authProvider.1=com.huawei.dj.zookeeper.auth.EnhancedAuthenticationProvider" >> "${ZOO_CFG}"
}

function config_zookeeper()
{
    mkdir -p ${SYS_LOG_DIR} ${DATA_DIR} ${DATA_LOG_DIR}
    /usr/bin/cp -f ${ZK_PATH}/apache-zookeeper/conf/zoo_sample.cfg ${ZOO_CFG}
    jre_path=`ls /usr/local/bin/jre | grep "^jre*"`
    sed -i "27a JAVA_HOME=/usr/local/bin/jre/${jre_path}" ${ZK_PATH}/apache-zookeeper/bin/zkEnv.sh
    sed -i "s/>\ \"\$_ZOO_DAEMON_OUT\"/>>\ \"\$_ZOO_DAEMON_OUT\"/" ${ZK_PATH}/apache-zookeeper/bin/zkServer.sh

    sed -i "28a ZOO_LOG_DIR=${SYS_LOG_DIR}" ${ZK_PATH}/apache-zookeeper/bin/zkEnv.sh
    sed -i '/zookeeper.log.dir=/ d' ${ZK_PATH}/apache-zookeeper/conf/log4j.properties
    sed -i "21a zookeeper.log.dir=$2" ${ZK_PATH}/apache-zookeeper/conf/log4j.properties
    sed -i "s/.out/.log/" ${ZK_PATH}/apache-zookeeper/bin/zkServer.sh

    _modify_zoo_cfg
    _modify_zoo_server
    _modify_JMXDISABLE
    _enhance_auth
}

function install_virtual_zookeeper()
{
    local v_zk_client_port=$(get_info.py v_zookeeper_client_port)
    /usr/bin/cp -rf ${ZK_PATH} ${V_ZK_PATH}
    sed -i '/dataLogDir/ d ' ${V_ZOO_CFG}
    echo "dataLogDir=${V_ZK_PATH}/logs" >> ${V_ZOO_CFG}
    sed -i '/clientPort/ d ' ${V_ZOO_CFG}
    echo "clientPort=${v_zk_client_port}" >> ${V_ZOO_CFG}
    sed -i '/clientPortAddress/ d ' ${V_ZOO_CFG}
    echo "clientPortAddress=${MANAGE_IP}" >> ${V_ZOO_CFG}
    sed -i '/dataDir=/ d ' ${V_ZOO_CFG}
    echo "dataDir=${V_ZK_PATH}/data" >> ${V_ZOO_CFG}
    echo "3" > ${V_ZK_PATH}/data/myid

    /usr/bin/cp -f "${CURRENT_PATH}"/tools/zookeeperControl.sh ${TOOL_PATH}/v_zookeeperControl.sh
    sed -i "s/bin\/zookeeper/bin\/v_zookeeper/g" ${TOOL_PATH}/v_zookeeperControl.sh
    sed -i "s/component=\"zookeeper\"/component=\"v_zookeeper\"/" ${TOOL_PATH}/v_zookeeperControl.sh
    sed -i "s/LOG_TAG=\"zookeeperControl\"/LOG_TAG=\"v_zookeeperControl\"/" ${TOOL_PATH}/v_zookeeperControl.sh
    set_least_common_permission ${TOOL_PATH}
    create_link ${TOOL_PATH}/v_zookeeperControl.sh
}

function chmod_zookeeper()
{
    chown -hR agentproxy:agentproxy /opt/huawei-data-protection/agentproxy
    set_least_rw_permission /var/log/huawei-data-protection
    local path=$(ls /usr/local/bin)
    for sub_dir in $path
    do
        if [ -d "/usr/local/bin/$sub_dir" ];then
            chmod 700 /usr/local/bin/$sub_dir
        else
            chmod 500 /usr/local/bin/$sub_dir
        fi
        set_least_common_permission /usr/local/bin/$sub_dir
    done

    set_least_rw_permission /usr/local/bin/zookeeper/apache-zookeeper/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/zookeeper/data >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/zookeeper/logs >/dev/null 2>&1

    set_least_rw_permission /usr/local/bin/v_zookeeper/apache-zookeeper/conf >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/v_zookeeper/data >/dev/null 2>&1
    set_least_rw_permission /usr/local/bin/v_zookeeper/logs >/dev/null 2>&1
}

log_info "Begin to install zookeeper..."
install_zookeeper
CHECK_RESULT $? "install_zookeeper failed."
config_zookeeper
CHECK_RESULT $? "config_zookeeper failed."
install_virtual_zookeeper
CHECK_RESULT $? "install virtual zookeeper failed."
chmod_zookeeper
CHECK_RESULT $? "chmod zookeeper failed."
log_info "Install zookeeper finished."
