#!/bin/bash
if [[ ${UID} -eq 0 ]];then
    sudo -u agentproxy bash $(dirname $(readlink -f $0))/$(basename $(readlink -f $0)) "$@";exit $?
elif [[ ${UID} -ne `get_info.py user_id operation_user` ]];then
    echo "Please switch to user(agentproxy) for run." && exit 1
fi

set +x
SERVICE_PATH="/usr/local/bin/zookeeper/apache-zookeeper"
ServiceState=""
component="zookeeper"
source /opt/huawei-data-protection/agentproxy/inst/bin/utils.sh
LOG_TAG="zookeeperControl"

function stopHeartBeat()
{
    proxython /usr/lib/proxython/site-packages/cps_monitor/heartBeat.py STOP ${component}
    if [[ $? -ne 0 ]]; then
        echo_error "Unregister heartbeat of ${component} failed..."
        return 1
    fi
    log_info "Unregister heartbeat of ${component} success..."
}

function startHeartBeat()
{
    proxython /usr/lib/proxython/site-packages/cps_monitor/heartBeat.py START ${component}
    if [[ $? -ne 0 ]]; then
        echo_error "Register heartbeat of ${component} failed..."
        return 1
    fi
    log_info "Register heartbeat of ${component} success..."
}

function component_run()
{
    echo "Begin start ${component}..."
    log_info "Begin start ${component}..."
    bash ${SERVICE_PATH}/bin/zkServer.sh status >/dev/null 2>&1
    if [[ $? -ne 1 ]]; then
        echo "${component} is running..."
        return 0
    fi
    fail_count=0
    while [ ${fail_count} -lt 3 ]; do
        bash ${SERVICE_PATH}/bin/zkServer.sh start >/dev/null 2>&1
        if [[ $? -eq 0 ]]; then
            startHeartBeat
            echo "Start ${component} success..."
            log_info "Start ${component} success..."
            return 0
        fi
        let ++fail_count
        echo "Start ${component} failed, fail_count=${fail_count}..."
        log_warn "Start ${component} failed, fail_count=${fail_count}..."
        sleep 10
    done
    echo "Start ${component} failed..."
    log_error "Start ${component} failed..."
    exit 1
}

function component_stop()
{
    echo "Begin stop ${component}..."
    log_info "Begin stop ${component}..."
    fail_count=0
    while [ ${fail_count} -lt 3 ]; do
        bash ${SERVICE_PATH}/bin/zkServer.sh stop >/dev/null 2>&1
        if [[ $? -eq 0 ]]; then
            stopHeartBeat
            echo "Stop ${component} success..."
            log_info "Stop ${component} success..."
            return 0
        fi
        let ++fail_count
        echo "Stop ${component} failed, fail_count=${fail_count}..."
        log_warn "Stop ${component} failed, fail_count=${fail_count}..."
        sleep 5
    done
    echo "Stop ${component} failed..."
    log_error "Stop ${component} failed..."
    exit 1
}

function component_status()
{
    zk_status=$(bash ${SERVICE_PATH}/bin/zkServer.sh status 2>/dev/null | grep -w "^Mode:" | awk '{print $NF}')
    if [[ "${zk_status}" == "standalone" ]];then
        echo -e "\n${component} role: standalone\n"
        exit 0
    fi
    if [[ "${zk_status}" == "leader" ]];then
        echo -e "\n${component} role: leader\n"
        exit 2
    fi
    if [[ "${zk_status}" == "follower" ]];then
        echo -e "\n${component} role: follower\n"
        exit 3
    fi
    echo -e "\n${component} probably dead\n"
    exit 1
}


while true; do
    case "$1" in
        -S) ServiceState=$2;shift 2; break;;
        -CS) CompStatus=$2;shift 2; break;;
        -A) Action=$2;shift 2; break;;
        *) shift; break;;
    esac
done
if [ "RESTART" = "${Action}" ]; then
    component_stop
    component_run
elif [ "RUN" = "${ServiceState}" ]; then
    component_run
elif [ "STOP" = "${ServiceState}" ]; then
    component_stop
elif [ "CompontState" = "${CompStatus}" ]; then
    component_status
else
    show_cmd_help ${component}
fi
exit 0

