import glob
import logging
import os
import os.path
import subprocess
import sys

from cinder.backup import ebackupconfig

logger = logging.getLogger('__EBACKUP_CONFIG__')


def whether_exist(file_path):
    if os.path.exists(file_path):
        ebackupconfig.set_log('eBackup driver has been exists.')
        print('%s has been exists, please uninstall it.' % os.path.basename(file_path))
        sys.exit(1)


def install_backup_drive():
    print('Installing the eBackup driver starts.')
    ebackupconfig.set_log('Install eBackup driver start.')
    cinder_install_path = ebackupconfig.get_install_path()

    # ===================check driver whether has been installed====================
    hwdriver_py_file = cinder_install_path + 'drivers/hwsebackup.py'
    hwdriveragent_py_file = cinder_install_path + 'drivers/ebackupagent.py'
    context_file = cinder_install_path + 'drivers/ebackupconst.py'
    whether_exist(hwdriver_py_file)
    whether_exist(hwdriveragent_py_file)
    whether_exist(context_file)

    rpm_prefix = cinder_install_path + '/../'
    rpm_pkg_path = os.path.dirname(os.path.abspath(__file__)) + '/../repo/'
    subprocess.run(['rpm', '-ivh', f'--prefix={rpm_prefix}'] +
                   glob.glob(f'{rpm_pkg_path}eBackup-cinder-backup-driver-*'), shell=False)

    ebackupconfig.set_log('Installing the eBackup driver completed.')
    print('Installing the eBackup driver completed.')


def install_backup_drive_slient(rpm_pkg_path):
    if not os.path.isfile(rpm_pkg_path):
        logger.info('Invalid install package.')
        sys.exit(1)
    logger.info('Installing the eBackup driver starts.')
    ebackupconfig.set_log('Install eBackup driver start.')
    cinder_install_path = ebackupconfig.get_install_path_slient()
    print('Install path %s' % cinder_install_path)

    rpm_prefix = cinder_install_path + '/../'
    cmd = ['rpm', '-Uvh', '--force', f'--prefix={rpm_prefix}', rpm_pkg_path]
    ret = subprocess.run(cmd, shell=False).returncode

    if ret != 0:
        logger.info('Install the eBackup driver failed, call rpm -ivh failed.')
        sys.exit(1)
    rm_cmd = ['rm', '-f'] + glob.glob(f'{cinder_install_path}/eBackup-cinder*.rpm')
    subprocess.run(rm_cmd, shell=False)
    cp_cmd = ['cp', '-f', rpm_pkg_path, cinder_install_path]
    subprocess.run(cp_cmd, shell=False)

    if ret != 0:
        logger.info('Install the eBackup driver failed, call mkdir and cp failed.')
        sys.exit(1)
    ebackupconfig.cinder_restart_all('/etc/cinder')

    ebackupconfig.set_log('Installing the eBackup driver completed.')
    logger.info('Installing the eBackup driver completed.')


if __name__ == "__main__":
    if len(sys.argv) == 3 and sys.argv[1] == 'install_silent':
        install_backup_drive_slient(sys.argv[2])
    else:
        install_backup_drive()
