import glob
import logging
import os
import shutil
import stat
import subprocess
import sys

import six

from cinder.backup import ebackupconfig

if six.PY3:
    import subprocess as cmds
else:
    import commands as cmds

logger = logging.getLogger('__EBACKUP_CONFIG__')

g_cinder_install_path = ebackupconfig.get_install_path()
g_config_path = '/etc/cinder'
g_env_file = '/tmp/upgrade/eBackupopenrc'


def remove_file(file_path):
    logger.debug("remove_file start. file_path: %s" % file_path)
    if os.path.exists(file_path):
        os.remove(file_path)


def copy_file(src_file, drt_file):
    logger.debug("copy_file start. src: %s , dest: %s " % (src_file, drt_file))
    if not os.path.exists(src_file):
        logger.error('source file is not exist, update failed.')
        sys.exit(1)
    if os.path.exists(drt_file):
        logger.debug('remove %s' % drt_file)
        os.remove(drt_file)
    shutil.copyfile(src_file, drt_file)


def backup_old_version():
    logger.debug("backup_old_version start.")
    gid = cmds.getoutput("cat /etc/passwd | grep -i -w \"^openstack\"|awk -F ':' '{print $4}'")
    uid = cmds.getoutput("cat /etc/passwd | grep -i -w \"^openstack\"|awk -F ':' '{print $3}'")
    global g_cinder_install_path
    '''installed file'''
    installed_files = ['drivers/hwsebackup.py', 'drivers/ebackupversion.conf', 'drivers/ebackupconst.py',
                       'drivers/ebackupagent.py', 'ebackupconfig.py', 'ebackupuninstall.py', 'cacert.pem',
                       'ebackup_config.ini', 'lib/cloudtools.py', 'lib/cpsrestful.py', 'lib/httprestful.py',
                       'lib/__init__.py', 'lib/ebackuprestful.py', 'lib/Uranus.py']

    '''clean old version backup files'''
    c10_backup_files = ['drivers/hwsebackup.hwroll', 'drivers/ebackupversion.hwroll', 'drivers/ebackupconst.hwroll',
                        'ebackupconfig.hwroll', 'ebackupuninstall.hwroll', 'cacert.hwroll']
    for bak_file in c10_backup_files:
        if os.path.exists(g_cinder_install_path + bak_file):
            remove_file(g_cinder_install_path + bak_file)
    '''clean config bak file last time'''
    if os.path.exists('/home/fsp/ebackup_conf.bak'):
        remove_file('/home/fsp/ebackup_conf.bak')
    '''clean backup files created at last'''
    backup_dir = ebackupconfig.BACKUP_PATH + 'ebackup_driver_backup/'
    if not os.path.exists(backup_dir):
        logger.debug("make backup floder: %s" % backup_dir)
        os.makedirs(backup_dir)
        os.chmod(backup_dir, stat.S_IWRITE | stat.S_IREAD | stat.S_IRGRP | stat.S_IROTH)
        os.chown(backup_dir, int(uid), int(gid))
    else:
        filelist = os.listdir(backup_dir)
        for f in filelist:
            remove_file(f)
    if not os.path.exists(backup_dir + 'drivers'):
        logger.debug("make backup driver floder: %sdrivers" % backup_dir)
        os.makedirs(backup_dir + 'drivers')
    if not os.path.exists(backup_dir + 'lib'):
        logger.debug("make backup lib floder: %slib" % backup_dir)
        os.makedirs(backup_dir + 'lib')

    '''backup file'''
    for filename in installed_files:
        if os.path.exists(g_cinder_install_path + filename):
            copy_file(g_cinder_install_path + filename, backup_dir + filename)
            os.chmod(backup_dir + filename, stat.S_IWRITE | stat.S_IREAD | stat.S_IRGRP | stat.S_IROTH)
            os.chown(backup_dir + filename, int(uid), int(gid))

    is_dj_env = ebackupconfig.is_dj_env()
    if is_dj_env:
        kmc_lib_path = "/usr/lib64/kmcadaptor"
        kmclib_bak_path = str(g_cinder_install_path) + 'lib_backup'
        if os.path.exists(kmclib_bak_path):
            shutil.rmtree(kmclib_bak_path)
        os.makedirs(kmclib_bak_path)

        src_kmc_adapter_file = str(g_cinder_install_path) + 'lib/libkmcadaptor.so'
        src_kmc_lib_file = str(kmc_lib_path) + '/libKMC.so'
        src_sdp_lib_file = str(kmc_lib_path) + '/libSDP.so'
        src_security_lib_file = str(kmc_lib_path) + '/libsecurec.so'
        src_ebackup_conf = str(g_cinder_install_path) + 'drivers/ebackup.conf'
        drt_kmc_adapter_file = kmclib_bak_path + '/libkmcadaptor.so'
        drt_kmc_lib_file = kmclib_bak_path + '/libKMC.so'
        drt_sdp_lib_file = kmclib_bak_path + '/libSDP.so'
        drt_security_lib_file = kmclib_bak_path + '/libsecurec.so'
        drt_ebackup_conf = str(g_cinder_install_path) + 'drivers/ebackup.hwroll'
        is_kmcpostfix = is_kmc_postfix()
        if is_kmcpostfix == True:
            src_kmc_lib_file = str(kmc_lib_path) + '/libKMC_ebk.so'
            src_sdp_lib_file = str(kmc_lib_path) + '/libSDP_ebk.so'
            drt_kmc_lib_file = kmclib_bak_path + '/libKMC_ebk.so'
            drt_sdp_lib_file = kmclib_bak_path + '/libSDP_ebk.so'
        copy_file(src_kmc_adapter_file, drt_kmc_adapter_file)
        copy_file(src_kmc_lib_file, drt_kmc_lib_file)
        copy_file(src_sdp_lib_file, drt_sdp_lib_file)
        copy_file(src_security_lib_file, drt_security_lib_file)
        remove_file(src_kmc_adapter_file)
        remove_file(src_kmc_lib_file)
        remove_file(src_sdp_lib_file)
        remove_file(src_security_lib_file)
        if os.path.exists(src_ebackup_conf):
            remove_file(drt_ebackup_conf)
            copy_file(src_ebackup_conf, drt_ebackup_conf)


def copy_rollback_uninstall_script():
    logger.debug("copy_rollback_script start.")
    current_path = os.path.dirname(os.path.abspath(__file__)) + '/cinder/backup/'
    if g_is_toolkit:
        current_path = '/tmp/upgrade/CinderDriver/cinder/backup/'
    src_rollback_script = current_path + '/../../rollback.py'
    drt_rollback_script = str(g_cinder_install_path) + 'ebackuprollback.py'
    copy_file(src_rollback_script, drt_rollback_script)
    os.chmod(drt_rollback_script, stat.S_IWRITE | stat.S_IREAD | stat.S_IRGRP | stat.S_IROTH)
    src_rollback_script = current_path + '/../../uninstall.py'
    drt_rollback_script = str(g_cinder_install_path) + 'ebackupuninstall.py'
    copy_file(src_rollback_script, drt_rollback_script)
    os.chmod(drt_rollback_script, stat.S_IWRITE | stat.S_IREAD | stat.S_IRGRP | stat.S_IROTH)


def upgrade_rpm():
    current_path = os.path.dirname(os.path.abspath(__file__)) + '../'
    if g_is_toolkit:
        current_path = '/tmp/upgrade/'

    pre_path = current_path + g_cinder_install_path + '/../'
    cmd = ['rpm', '-Uvh', '--force', f'--prefix={pre_path}' +
           glob.glob(f'{current_path}eBackup-cinder-backup-driver-*')]
    subprocess.run(cmd, shell=False)


def rollbackup_version():
    logger.debug("rollbackup_version start.")
    gid = cmds.getoutput("cat /etc/passwd | grep -i -w \"^openstack\"|awk -F ':' '{print $4}'")
    uid = cmds.getoutput("cat /etc/passwd | grep -i -w \"^openstack\"|awk -F ':' '{print $3}'")
    backup_dir = ebackupconfig.BACKUP_PATH + 'ebackup_driver_backup/'
    if not os.path.exists(backup_dir):
        logger.error("No backup file found.Don't delete current file")
        return
    # remove installed file
    install_file_list = ['drivers/hwsebackup.py', 'drivers/ebackupagent.py', 'drivers/ebackupversion.conf',
                         'drivers/ebackupconst.py', 'ebackupconfig.py', 'ebackupuninstall.py', 'cacert.pem',
                         'ebackup_config.ini', 'lib/cloudtools.py', 'lib/httprestful.py', 'lib/cpsrestful.py',
                         'lib/__init__.py', 'lib/ebackuprestful.py', 'lib/Uranus.py']
    for newfile in install_file_list:
        '''restore backup file '''
        if os.path.exists(backup_dir + newfile):
            '''remove upgraded file'''
            remove_file(g_cinder_install_path + newfile)
            copy_file(backup_dir + newfile, g_cinder_install_path + newfile)
            os.chmod(g_cinder_install_path + newfile, stat.S_IWRITE | stat.S_IREAD | stat.S_IRGRP | stat.S_IROTH)
            os.chown(g_cinder_install_path + newfile, int(uid), int(gid))

    if os.path.exists(backup_dir):
        shutil.rmtree(backup_dir)

    kmc_lib_path = "/usr/lib64/kmcadaptor"
    kmclib_bak_path = str(g_cinder_install_path) + 'lib_backup'

    is_dj_env = ebackupconfig.is_dj_env()
    if not is_dj_env:
        primary_keystore_file = "/home/openstack/primary_keystore.dat"
        standby_keystore_file = "/home/openstack/standby_keystore.dat"
        primary_kmc_cfg_file = "/home/openstack/primary_kmc_cfg.conf"
        standby_kmc_cfg_file = "/home/openstack/standby_kmc_cfg.conf"
        hwbackup_conf = g_cinder_install_path + 'drivers/ebackup.conf'
        remove_file(hwbackup_conf)
        remove_file(primary_keystore_file)
        remove_file(standby_keystore_file)
        remove_file(primary_kmc_cfg_file)
        remove_file(standby_kmc_cfg_file)
        if os.path.exists(kmc_lib_path):
            shutil.rmtree(kmc_lib_path)
    else:
        drt_kmc_adapter_file = str(g_cinder_install_path) + 'lib/libkmcadaptor.so'
        drt_kmc_lib_file = str(kmc_lib_path) + '/libKMC.so'
        drt_sdp_lib_file = str(kmc_lib_path) + '/libSDP.so'
        drt_security_lib_file = str(kmc_lib_path) + '/libsecurec.so'
        drt_ebackup_conf = str(g_cinder_install_path) + 'drivers/ebackup.conf'
        src_kmc_adapter_file = kmclib_bak_path + '/libkmcadaptor.so'
        src_kmc_lib_file = kmclib_bak_path + '/libKMC.so'
        src_sdp_lib_file = kmclib_bak_path + '/libSDP.so'
        src_security_lib_file = kmclib_bak_path + '/libsecurec.so'
        src_ebackup_conf = str(g_cinder_install_path) + 'drivers/ebackup.hwroll'

        remove_file(drt_kmc_lib_file)
        remove_file(drt_sdp_lib_file)
        remove_file(str(kmc_lib_path) + '/libKMC_ebk.so')
        remove_file(str(kmc_lib_path) + '/libSDP_ebk.so')
        remove_file(drt_ebackup_conf)

        is_kmcpostfix = is_backup_kmc_postfix()
        if is_kmcpostfix:
            drt_kmc_lib_file = str(kmc_lib_path) + '/libKMC_ebk.so'
            drt_sdp_lib_file = str(kmc_lib_path) + '/libSDP_ebk.so'
            src_kmc_lib_file = kmclib_bak_path + '/libKMC_ebk.so'
            src_sdp_lib_file = kmclib_bak_path + '/libSDP_ebk.so'

        copy_file(src_kmc_adapter_file, drt_kmc_adapter_file)
        copy_file(src_kmc_lib_file, drt_kmc_lib_file)
        copy_file(src_sdp_lib_file, drt_sdp_lib_file)
        copy_file(src_security_lib_file, drt_security_lib_file)
        os.chmod(drt_kmc_adapter_file,
                 stat.S_IEXEC | stat.S_IREAD | stat.S_IRGRP | stat.S_IXGRP | stat.S_IROTH | stat.S_IXOTH)
        os.chmod(drt_kmc_lib_file,
                 stat.S_IEXEC | stat.S_IREAD | stat.S_IRGRP | stat.S_IXGRP | stat.S_IROTH | stat.S_IXOTH)
        os.chmod(drt_sdp_lib_file,
                 stat.S_IEXEC | stat.S_IREAD | stat.S_IRGRP | stat.S_IXGRP | stat.S_IROTH | stat.S_IXOTH)
        os.chmod(drt_security_lib_file,
                 stat.S_IEXEC | stat.S_IREAD | stat.S_IRGRP | stat.S_IXGRP | stat.S_IROTH | stat.S_IXOTH)

        if os.path.exists(src_ebackup_conf):
            os.rename(src_ebackup_conf, drt_ebackup_conf)
    subprocess.run(['rm', '-f'] + glob.glob(f'{g_cinder_install_path}/eBackup-cinder*.rpm'), shell=False)


def check_need_upgrade():
    logger.debug("check_need_upgrade start.")
    ebackup_version_file_path = str(g_cinder_install_path) + 'drivers/ebackupversion.conf'
    if os.path.exists(ebackup_version_file_path):
        f = open(ebackup_version_file_path)
        cur_version = f.readline()
        f.close()
    else:
        return True
    cur_path = os.path.dirname(os.path.abspath(__file__))
    if g_is_toolkit:
        cur_path = "/tmp/upgrade/CinderDriver"
    new_version_file_path = cur_path + "/cinder/backup/drivers/ebackupversion.conf"
    src_version_file = open(new_version_file_path)
    new_version = src_version_file.readline()
    src_version_file.close()

    if new_version == cur_version:
        return False
    else:
        return True


def is_kmc_postfix():
    logger.debug("is_kmc_postfix start.")
    kmc_lib_path = "/usr/lib64/kmcadaptor"
    kmc_file_path = str(kmc_lib_path) + '/libKMC_ebk.so'
    if os.path.exists(kmc_file_path):
        return True
    else:
        return False


def is_backup_kmc_postfix():
    logger.debug("is_backup_kmc_postfix start.")
    kmc_file_path = str(g_cinder_install_path) + 'lib_backup/libKMC_ebk.so'
    if os.path.exists(kmc_file_path):
        return True
    else:
        return False


def upgrade_main():
    logger.debug("update eBackup driver start.")
    print("upgrading, wait ......")
    try:
        backup_old_version()
        upgrade_rpm()
    except Exception as msg:
        print("upgrade failed, please check env.")
        logger.error("upgrade failed.")
        logger.error(msg)
        sys.exit(1)
    copy_rollback_uninstall_script()
    ebackupconfig.cinder_restart_all(g_config_path)
    logger.debug("update eBackup driver finish.")


def roll_main():
    logger.debug("roll eBackup driver start.")
    print("rolling, wait......")
    rollbackup_version()
    ebackupconfig.cinder_restart_all(g_config_path)
    logger.debug("roll eBackup driver finish.")


def repaire_encrypt_items():
    logger.debug("repaire config.")


if __name__ == '__main__':
    try:
        g_is_toolkit = False
        if len(sys.argv) == 2:
            if sys.argv[1] == 'upgrade':
                be_need_upgrade = check_need_upgrade()
                if be_need_upgrade:
                    upgrade_main()
                else:
                    print("no need to upgrade")
            elif sys.argv[1] == 'rollback':
                roll_main()
            else:
                print("wrong parameter")
                sys.exit(1)
        elif len(sys.argv) in [4, 6]:
            g_is_toolkit = True
            if not os.path.isdir(str(sys.argv[2])) or \
                    not os.path.isdir(sys.argv[3]):
                print("Incorrect script parameters. "
                      "Parameters 2 and 3 must be valid file paths.")
                sys.exit(1)

            tmp_path = ""
            if not sys.argv[2].endswith("/"):
                tmp_path = "{}/".format(sys.argv[2])
            if tmp_path not in [
                "/usr/lib/python3.7/site-packages/cinder/backup/",
                "/usr/lib/python2.7/site-packages/cinder/backup/",
                "/usr/lib64/python2.7/site-packages/cinder/backup/",
                "/opt/cloud/services/cascading-cinder/venv/lib/python2.7"
                "/site-packages/cinder/backup/"
            ]:
                print("Parameter 2 is not a allowed path.")
                sys.exit(1)
            g_cinder_install_path = tmp_path

            tmp_path = sys.argv[3].rstrip("/")
            if tmp_path != "/etc/cinder":
                print("Parameter 3 is not a allowed path.")
                sys.exit(1)
            g_config_path = tmp_path

            g_retry_count = 90
            g_retry_time_interval = 30
            logger.debug("g_cinder_install_path: %s, g_config_path: %s, g_retry_count: %d, g_retry_time_interval: %d" %
                         (g_cinder_install_path, g_config_path, g_retry_count, g_retry_time_interval))
            ret = 0
            is_dj_env = ebackupconfig.is_dj_env()
            if is_dj_env == False:
                source_cmd = ['source', g_env_file]
                ret = subprocess.run(source_cmd, shell=False).returncode
            if ret != 0:
                logger.debug("source env file failed.")
                sys.exit(1)
            if str(sys.argv[1]) == "upgrade":
                upgrade_main()
            elif str(sys.argv[1]) == "upgrade_self":
                upgrade_main()
            elif str(sys.argv[1]) == "rollback":
                roll_main()
            elif str(sys.argv[1]) == "repaire":
                repaire_encrypt_items()
            else:
                logger.debug("wrong parameter.")
                sys.exit(1)
        else:
            print("wrong parameter")
            logger.debug("wrong parameter.")
            sys.exit(1)
    except Exception as e:
        logger.error("upgrade.py error : %s" % e)
        sys.exit(1)
