#!/bin/bash
G_UPGRADE_BACKUP=/var/ebackup_bak
G_UPGRADE_TMP=/tmp/upgrade
G_UPGRADE_SCRIPT_PATH=${G_UPGRADE_TMP}/upgrade_pkg/upgrade
source /opt/huawei-data-protection/ebackup/sbin/log.sh

function upgrade_backup_clean()
{
    log_info "start to clean backup data when upgrading "
    if [ -d ${G_UPGRADE_BACKUP} ];then
        rm -rf "${G_UPGRADE_BACKUP}"
        if [ $? -ne 0 ];then
            log_error "clean backup data field."
            return 1
        fi
    else
        log_error "backup data file not exit."
    fi
    return 0
}


#******************************************************************#
# Function: main
# Description: Main workflow
# Input Parameters:
#
# Returns:
#   0 NORMAL
#   1 ERROR
#******************************************************************#
function main()
{
    log_info "start clean"
    
    upgrade_backup_clean
    if [ $? -ne 0  ];then
        log_error "[main(),$LINENO]upgrade backup clean failed."
        exit 1
    fi
}

main "$@"
exit $?
