function cut_hosts()
{
    local symbol=$1
    local host_file="hosts"
    if [ $# -eq 1 ];then
        host_file="hosts"
    elif [ $# -eq 2 ];then
        host_file=$2
    fi
    local ipv4_regex="((25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])\.){3}(25[0-5]|2[0-4][0-9]|1[0-9]{2}|[1-9][0-9]|[0-9])"
    local ipv6_regex="^\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])(\.(25[0-5]|2[0-4][0-9]|1[0-9][0-9]|[1-9]?[0-9])){3}))|:)))(%.+)?\s*$"
    grep "${symbol}" ${host_file} >/dev/null 2>&1
    if [ $? -ne 0 ];then
        echo "There is no section([$1]) exist in ${host_file} file!"
        exit 1
    fi
    
    sed -n '/'${symbol}'/,/\[/ p' ${host_file} > hosts_temp
    local one_driver_ip=`cat hosts_temp | egrep -w -m1 "${ipv4_regex}"`
    if [ -z "${one_driver_ip}" ];then
        one_driver_ip=`cat hosts_temp | grep -m 1 "ansible_ssh_host"`
        if [ $? -ne 0 ];then
            echo "There is no IP address of [$1] exist in host file! "
            exit 1
        fi
        local ipv6_address=$(echo ${one_driver_ip} | awk -F "=" '{print $2}' | sed $'s/\'//g')
        echo ${ipv6_address} | egrep "${ipv6_regex}" >/dev/null 2>&1
        if [ $? -ne 0 ];then
            echo "The ip($one_driver_ip) is invalid!"
            exit 1
        fi
    fi
    
    echo -e "[${symbol}]\n$one_driver_ip" > ${host_file}
}

