import glob
import logging
import os
import shutil
import stat
import subprocess
import sys

import six

from cinder.backup import ebackupconfig

if six.PY2:
    import commands

logger = logging.getLogger('__EBACKUP_CONFIG__')

g_cinder_install_path = ''
g_config_path = '/etc/cinder'
kmc_lib_path = "/usr/lib64/kmcadaptor"


def del_keylist():
    keylist_file_path = "/etc/FSSecurity/keylist.ini"
    if not os.path.exists(keylist_file_path):
        return
    fp = open(keylist_file_path)
    lines = []
    for line in fp:
        strline = str(line).strip()
        if strline in ["ebackup_login_password_v2", "ebackup_storage_username_v2", "ebackup_storage_password_v2"]:
            continue
        lines.append(strline)
    fp.close()

    final_context = '\n'.join(lines)
    flags = os.O_WRONLY | os.O_CREAT | os.O_TRUNC
    modes = stat.S_IWUSR | stat.S_IRUSR
    fp = os.fdopen(os.open(keylist_file_path, flags, modes), 'w')
    fp.write(final_context)
    fp.close()


def set_cps_command_enviorment(cps_name, cps_pwd):
    os.environ['OS_USERNAME'] = cps_name
    os.environ['OS_PASSWORD'] = cps_pwd
    cmd = 'cps host-list'.split(" ")
    pipe = subprocess.Popen(cmd, shell=False, stdout=subprocess.PIPE).stdout
    cps_host_list_result = pipe.read()
    if six.PY3:
        cps_host_list_result = str(cps_host_list_result, encoding='utf-8')
    if cps_host_list_result.find('locked') != -1:
        print("OS user is current locked, please input again later.")
        return ebackupconfig.DMK_RET_FAILED
    elif cps_host_list_result.find('id') == -1 and cps_host_list_result.find('status') == -1:
        print("OS_USERNAME or OS_PASSWORD is invalid, please input again.")
        return ebackupconfig.DMK_RET_FAILED
    else:
        print("setenv successfully")
        return ebackupconfig.DMK_RET_SUCESS


def remove_file(file_path):
    logger.debug("remove start.  %s " % file_path)
    if os.path.exists(file_path):
        os.remove(file_path)


def copy_file(src_file, drt_file):
    logger.debug("copy_file start. src: %s , dest: %s " % (src_file, drt_file))
    if not os.path.exists(src_file):
        print('Copy file failed. Source file %s is not exist' % src_file)
        sys.exit()
    if os.path.exists(drt_file):
        os.remove(drt_file)
    shutil.copyfile(src_file, drt_file)


def remove_hwroll(hwroll_file):
    if os.path.exists(hwroll_file):
        os.remove(hwroll_file)


def _copy_backup_file(backup_dir, newfile, new_path, uid, gid):
    remove_file(new_path + newfile)
    copy_file(backup_dir + newfile, new_path + newfile)
    os.chmod(new_path + newfile, stat.S_IWRITE | stat.S_IREAD | stat.S_IRGRP | stat.S_IROTH)
    os.chown(new_path + newfile, int(uid), int(gid))


def _copy_backup_dir(backup_dir, newdir, new_path, uid, gid):
    if os.path.exists(new_path + newdir):
        shutil.rmtree(new_path + newdir)
    shutil.copytree(backup_dir + newdir, new_path + newdir)
    # 文件夹权限为755
    permission = stat.S_IRUSR | stat.S_IWUSR | stat.S_IXUSR | stat.S_IRGRP | stat.S_IXGRP | stat.S_IROTH | stat.S_IXOTH
    os.chmod(new_path + newdir, permission)
    os.chown(new_path + newdir, int(uid), int(gid))


def rollbackup_version():
    print("rollbackup_version start.")
    backup_dir = ebackupconfig.BACKUP_PATH + 'ebackup_driver_backup/'
    if not os.path.exists(backup_dir):
        print("No backup file found.Don't delete current file")
        return
    if six.PY3:
        gid = subprocess.getoutput("cat /etc/passwd | grep -i -w \"^openstack\"|awk -F ':' '{print $4}'")
        uid = subprocess.getoutput("cat /etc/passwd | grep -i -w \"^openstack\"|awk -F ':' '{print $3}'")
    else:
        gid = commands.getoutput("cat /etc/passwd | grep -i -w \"^openstack\"|awk -F ':' '{print $4}'")
        uid = commands.getoutput("cat /etc/passwd | grep -i -w \"^openstack\"|awk -F ':' '{print $3}'")
    '''installed file'''
    installed_files = ['drivers/hwsebackup.py', 'drivers/ebackupversion.conf', 'drivers/ebackupconst.py',
                       'drivers/ebackupagent.py', 'ebackupconfig.py', 'ebackupuninstall.py', 'cacert.pem',
                       'ebackup_config.ini', 'lib/cloudtools.py', 'lib/cpsrestful.py', 'lib/httprestful.py',
                       'lib/__init__.py', 'lib/ebackuprestful.py', 'lib/Uranus.py', 'driver_inspect_tool.py',
                       'ebackuprollback.py', 'lib/configlog.py', 'lib/migrate_tool.py']

    installed_dir = ['lib/datastore']

    for newfile in installed_files:
        '''restore backup file '''
        if os.path.exists(backup_dir + newfile):
            '''remove upgraded file'''
            _copy_backup_file(backup_dir, newfile, g_cinder_install_path, uid, gid)
            _copy_backup_file(backup_dir, newfile, ebackupconfig.BACKUP_PATH, uid, gid)

    for newdir in installed_dir:
        '''restore backup file '''
        if os.path.exists(backup_dir + newdir):
            _copy_backup_dir(backup_dir, newdir, g_cinder_install_path, uid, gid)
            _copy_backup_dir(backup_dir, newdir, ebackupconfig.BACKUP_PATH, uid, gid)

    if os.path.exists(backup_dir):
        shutil.rmtree(backup_dir)

    kmc_lib_path = "/usr/lib64/kmcadaptor"
    kmclib_bak_path = str(g_cinder_install_path) + 'lib_backup'
    is_dj_env = ebackupconfig.is_dj_env()
    if is_dj_env is False:
        remove_file("/home/openstack/primary_keystore.dat")
        remove_file("/home/openstack/standby_keystore.dat")
        remove_file("/home/openstack/primary_kmc_cfg.conf")
        remove_file("/home/openstack/standby_kmc_cfg.conf")
        if os.path.exists(kmc_lib_path):
            shutil.rmtree(kmc_lib_path)
    else:
        drt_kmc_adapter_file = str(g_cinder_install_path) + 'lib/libkmcadaptor.so'
        drt_kmc_lib_file = str(kmc_lib_path) + '/libKMC.so'
        drt_sdp_lib_file = str(kmc_lib_path) + '/libSDP.so'
        drt_security_lib_file = str(kmc_lib_path) + '/libsecurec.so'
        drt_ebackup_conf = str(g_cinder_install_path) + 'drivers/ebackup.conf'
        src_kmc_adapter_file = kmclib_bak_path + '/libkmcadaptor.so'
        src_kmc_lib_file = kmclib_bak_path + '/libKMC.so'
        src_sdp_lib_file = kmclib_bak_path + '/libSDP.so'
        src_security_lib_file = kmclib_bak_path + '/libsecurec.so'
        src_ebackup_conf = str(g_cinder_install_path) + 'drivers/ebackup.hwroll'

        remove_file(drt_kmc_lib_file)
        remove_file(drt_sdp_lib_file)
        remove_file(str(kmc_lib_path) + '/libKMC_ebk.so')
        remove_file(str(kmc_lib_path) + '/libSDP_ebk.so')
        remove_file(drt_ebackup_conf)

        is_kmcpostfix = is_backup_kmc_postfix()
        if is_kmcpostfix is True:
            drt_kmc_lib_file = str(kmc_lib_path) + '/libKMC_ebk.so'
            drt_sdp_lib_file = str(kmc_lib_path) + '/libSDP_ebk.so'
            src_kmc_lib_file = kmclib_bak_path + '/libKMC_ebk.so'
            src_sdp_lib_file = kmclib_bak_path + '/libSDP_ebk.so'

        copy_file(src_kmc_adapter_file, drt_kmc_adapter_file)
        copy_file(src_kmc_lib_file, drt_kmc_lib_file)
        copy_file(src_sdp_lib_file, drt_sdp_lib_file)
        copy_file(src_security_lib_file, drt_security_lib_file)
        os.chmod(drt_kmc_adapter_file,
                 stat.S_IEXEC | stat.S_IREAD | stat.S_IRGRP | stat.S_IXGRP | stat.S_IROTH | stat.S_IXOTH)
        os.chmod(drt_kmc_lib_file,
                 stat.S_IEXEC | stat.S_IREAD | stat.S_IRGRP | stat.S_IXGRP | stat.S_IROTH | stat.S_IXOTH)
        os.chmod(drt_sdp_lib_file,
                 stat.S_IEXEC | stat.S_IREAD | stat.S_IRGRP | stat.S_IXGRP | stat.S_IROTH | stat.S_IXOTH)
        os.chmod(drt_security_lib_file,
                 stat.S_IEXEC | stat.S_IREAD | stat.S_IRGRP | stat.S_IXGRP | stat.S_IROTH | stat.S_IXOTH)

        if os.path.exists(src_ebackup_conf):
            os.rename(src_ebackup_conf, drt_ebackup_conf)

    rollback_script = str(g_cinder_install_path) + 'ebackuprollback.py'
    remove_file(rollback_script)
    subprocess.run(['rm', '-f'] + glob.glob(f'{g_cinder_install_path}/eBackup-cinder*.rpm'), shell=False)


def check_can_rollback():
    hwdriver_hwroll_file = str(g_cinder_install_path) + 'drivers/hwsebackup.hwroll'
    if not os.path.exists(hwdriver_hwroll_file):
        print('Can not rollback because the rollback file does not exsit.')
        return False
    return True


def is_kmc_postfix():
    kmc_lib_path = "/usr/lib64/kmcadaptor"
    kmc_file_path = str(kmc_lib_path) + 'libKMC_ebk.so'
    if os.path.exists(kmc_file_path):
        return True
    else:
        return False


def is_backup_kmc_postfix():
    kmc_file_path = str(g_cinder_install_path) + 'lib_backup/libKMC_ebk.so'
    if os.path.exists(kmc_file_path):
        return True
    else:
        return False


def roll_config(cps_name, cps_pwd_file, cps_password=""):
    print('roll to backup config')
    dmkconfig = ebackupconfig.DmkConfig(cps_name, cps_pwd_file, cps_password)
    if set_cps_command_enviorment(dmkconfig.cps_name, dmkconfig.cps_pwd_value) == ebackupconfig.DMK_RET_SUCESS:
        try:
            dmkconfig.upgrade_config_rollback()
        except Exception as e:
            logger.error(str(e))
            sys.exit(1)
    else:
        print('cps username or password is wrong,please check')
        sys.exit(1)


def roll_file(cps_name, cps_file):
    print('roll to backup config')
    dmkconfig = ebackupconfig.DmkConfig(cps_name, cps_file)
    if set_cps_command_enviorment(dmkconfig.cps_name, dmkconfig.cps_pwd_value) == ebackupconfig.DMK_RET_SUCESS:
        rollbackup_version()
        ebackupconfig.cinder_restart_all(g_config_path)
    else:
        print('cps username or password is wrong,please check')
        sys.exit(1)


def roll_version_only():
    rollbackup_version()
    ebackupconfig.cinder_restart_all(g_config_path)


if __name__ == '__main__':
    g_cinder_install_path = ebackupconfig.get_install_path_slient()
    # rollback config
    if sys.argv.__len__() == 4 and sys.argv[1] == "config" and os.path.isfile(sys.argv[3]):
        roll_config(sys.argv[2], cps_pwd_file=sys.argv[3])
    # rollback file
    elif sys.argv.__len__() == 4 and sys.argv[1] == "file" and os.path.isfile(sys.argv[3]):
        print("Rollbacking, please wait for a moment......")
        roll_file(sys.argv[2], sys.argv[3])
    elif sys.argv.__len__() == 2 and sys.argv[1] == 'rollback_file':
        roll_version_only()
    else:
        rollback_conf = False
        choose = six.moves.input('Do you want to rollback eBackup driver? (y/n)(default:n):')
        if choose == 'Y' or choose == 'y':
            cps_user, cps_pass = ebackupconfig.set_env_var()
            g_cinder_install_path = ebackupconfig.get_install_path()
            g_config_path = ebackupconfig.input_config_path()
            is_rollback_conf = six.moves.input('Do you want to rollback eBackup driver conf? (y/n)(default:n):')
            if is_rollback_conf == 'Y' or is_rollback_conf == 'y':
                rollback_conf = True
            elif is_rollback_conf == 'N' or is_rollback_conf == 'n' or is_rollback_conf == '':
                rollback_conf = False
            else:
                print('Invalid input.')
            print("Rollbacking, please wait for a moment......")
            rollbackup_version()
            if rollback_conf:
                roll_config(cps_user, '', cps_password=cps_pass)
            ebackupconfig.cinder_restart_all(g_config_path)
            print("Rollback succeeded")
        else:
            print('quit rollback')
