#!/bin/bash

#source common files
scriptDir=$(cd "$(dirname $0)"; pwd)
ansible_host_file=$scriptDir/ansible_hosts

#print usage info
function usage()
{
    Info="
Usage:
    bash /path/to/generateConfig.sh /path/to/srcIpListfile
Exam:
    bash ./generateConfig.sh ./biere_cna.txt"
    echo "$Info"

    return 0
}

#input param check
if [ $# -ne 1 ]; then
    usage
    exit 1
elif [ ! -f "$1" ]; then
    echo "Source Ip list file <$1> doesn't exist! Please check it."
    exit 1
fi

dos2unix "$1" 2>/dev/null
srcfilePath=$(dirname $1)
srcfileName=$(basename $1)
sshuser="{{remote_ssh_user}}"
methodtmp=$(cat $1|grep "method=")
method=${methodtmp:7}

echo "">> "$ansible_host_file"
echo "[$method]" > "$ansible_host_file"
staticIp_list=$(cat $1| grep static_hosts | tr -d '\r\n' | awk -F= '{print $2}' | sed  's/,/ /g')
let i=0
for staticLine in $staticIp_list; do
    echo -e "static_0_host${i} \tansible_ssh_user=$sshuser \tansible_ssh_host=${staticLine}" >> "$ansible_host_file"
    let i=i+1
done

exit 0