import os

import time
import win32event
import win32service
import win32serviceutil

from agentassisthandle.start import AgentAssistStartProcess
from agentassisthandle.stop import AgentAssistStopProcess
from common.logutils import Logger, AGENT_ASSIST_MANAGER_LOG
from common.utils import Utils

install_path = Utils.get_install_path()
log = Logger().get_logger(AGENT_ASSIST_MANAGER_LOG)
stop_process = AgentAssistStopProcess()
start_process = AgentAssistStartProcess()


class AgentAssistMonitorService(win32serviceutil.ServiceFramework):
    # 服务名
    _svc_name_ = Utils.monitor_service_name
    _svc_display_name_ = Utils.monitor_service_name

    def __init__(self, args):
        win32serviceutil.ServiceFramework.__init__(self, args)
        self.hWaitStop = win32event.CreateEvent(None, 0, 0, None)
        self._monitor_process_count = 0
        self.is_alive = True

    def SvcDoRun(self):
        log.info("svc do run client assistant monitor service")
        start_process.run_process()
        log.info("The AgentAssist_monitor service is started successfully.")
        while self.is_alive:
            time.sleep(5)
            if Utils.check_process(Utils.monitor_file):
                self._monitor_process_count = 0
            else:
                self._monitor_process_count += 1
                log.info(f"monitor process does not exist. The value of "
                         f"monitor_process_count:{self._monitor_process_count}")

            if self._monitor_process_count > 3:
                self._monitor_process_count = 0
                file_path = os.path.join(install_path,
                                         'AgentAssist/bin/assist/monitor.py')
                try:
                    python_path = Utils.get_python_path()
                    Utils.execute_cmd([python_path, file_path])
                    log.info("monitor is successfully started.")
                except Exception as err:
                    log.error(f'Failed to start the monitor process. {err}')

        if not self.is_alive:
            log.info("svc do client assistant assist monitor process")
            stop_process.stop_process(Utils.monitor_file)
            stop_process.stop_process(Utils.rdagent_file)
            stop_process.stop_process(Utils.log_package_file)
            log.info("Succeeded in stopping the service.")

    def SvcStop(self):
        # 先告诉SCM停止这个过程
        log.info("svc do stop client assistant monitor servics")

        self.ReportServiceStatus(win32service.SERVICE_STOP_PENDING)
        # 设置事件
        win32event.SetEvent(self.hWaitStop)
        self.is_alive = False


if __name__ == '__main__':
    win32serviceutil.HandleCommandLine(AgentAssistMonitorService,
                                       argv=['monitor', 'install'])
