import getpass
import logging
import os
import stat
import sys

from common.configreader import g_cfg_agentassist, g_cfg_iam
from kmc import kmc

FLAGS = os.O_WRONLY | os.O_CREAT
MODES = stat.S_IWUSR | stat.S_IRUSR


def save_ak_sk():
    secret_key = kmc.API().encrypt(0, input_secret, cipher_type)
    g_cfg_iam.set_option("iam", "access_key", access)
    g_cfg_iam.set_option("iam", "secret_key", secret_key)


if __name__ == '__main__':
    if len(sys.argv) != 2:
        sys.exit(1)
    try:
        cipher_type = g_cfg_agentassist.get_option('proxy', 'cipher_type')
    except Exception as err:
        logging.error(f'The cipher type error.{err}')
        sys.exit(1)
    if not cipher_type:
        logging.error('The cipher type is none.')
        sys.exit(1)
    install_path = os.path.realpath(sys.argv[1])
    access = input('Enter your Access Key Id:')
    input_secret = getpass.getpass('Enter your Secret Access Key:')
    try:
        save_ak_sk()
    except Exception as err:
        logging.error(f'The ak sk save error.{err}')
        sys.exit(1)
    logging.info(f'The ak sk save succ.')
    sys.exit(0)
