# coding: utf-8
"""
Unify backup error code define file
"""

AGENTASSIST_INSTALL = "Assist_Install"
SUBAGENT_INSTALL = "SubAgent_Install"
RDAGENT = "Rdagent"
MONITOR = "Monitor"
GENERAL_ERROR = {
    "msg": "Unknown error.",
    "code": "assist-1000"
}

ASSIST_ERROR_DETAIL = {
    "10": {
        "msg": "Target path space not enough.",
        "code": "assist-1001"
    },
    "11": {
        "msg": "Current user has no permission.",
        "code": "assist-1002"
    },
    "12": {
        "msg": "Crt info not correct.",
        "code": "assist-1003"
    },
    "13": {
        "msg": "IP info error.",
        "code": "assist-1004"
    },
    "14": {
        "msg": "IP info error.",
        "code": "assist-1005"
    },
}

SUBAGENT_ERROR_DETAIL = {
    "10": {
        "msg": "Target path space not enough.",
        "code": "assist-2000"
    },
}

RDAGENT_ERROR_DETAIL = {
    "10": {
        "msg": "network error.",
        "code": "assist-3000"
    },
    "11": {
        "msg": "header length error.",
        "code": "assist-3001"
    },
}

MONITOR_ERROR_DETAIL = {
    "10": {
        "msg": "cannot fetch system info.",
        "code": "assist-4000"
    },
    "11": {
        "msg": "start rdagent error.",
        "code": "assist-4001"
    },
}


class AssistErrorDetailBuilder(object):
    """Assist error details builder"""

    @staticmethod
    def build(code, module=RDAGENT):
        """Construct error details returned by AgentAssist"""
        if not code:
            return GENERAL_ERROR

        error_detail = ""
        if module == RDAGENT:
            error_detail = RDAGENT_ERROR_DETAIL.get(code)
        elif module == AGENTASSIST_INSTALL:
            error_detail = ASSIST_ERROR_DETAIL.get(code)
        elif module == SUBAGENT_INSTALL:
            error_detail = SUBAGENT_ERROR_DETAIL.get(code)
        elif module == MONITOR:
            error_detail = MONITOR_ERROR_DETAIL.get(code)

        if not error_detail:
            return GENERAL_ERROR

        return error_detail
