#!/usr/bin/python3
import logging
import os

from concurrent_log_handler import ConcurrentRotatingFileHandler

from common.common_define import CommonDefine
from common.common_define import Permission
from common.configreader import INSTALL_PATH
from common.configreader import g_cfg_agentassist
from common.utils import AgentConf

# 助手安装/升级/卸载日志
AGENT_ASSIST_INSTALL_LOG = "AgentAssist_install.log"
# 子agent安装/升级/卸载日志
SUBAGENT_INSTALL_LOG = "subagent_install.log"
AGENT_ASSIST_MANAGER_LOG = "AgentAssist_manager.log"
# rdagent进程日志
RDAGENT_LOG = "rdagent.log"
# monitor进程日志
MONITOR_LOG = "monitor.log"


class Logger(object):

    def __init__(self):
        self._formatter_str = "[%(asctime)s][%(name)s]:[%(threadName)s]:" \
                              "[%(levelname)s], [%(filename)s]:[%(lineno)s];" \
                              "[%(funcName)s];[%(message)s]"
        self._path = os.path.join(INSTALL_PATH, 'AgentAssist/log')
        self._chmod = None if CommonDefine.IS_WINDOWS else \
            Permission.PERMISSION_600
        if not os.path.exists(self._path):
            os.makedirs(self._path, mode=0o700)
        self._init_param()

    def _init_param(self):
        self._max_log_size_mb = g_cfg_agentassist.get_int_option('agent_log', 'max_log_size_mb')
        if not AgentConf.check_param(AgentConf.MIN_LOG_FILE_SIZE_MB, self._max_log_size_mb,
                                     AgentConf.MAX_LOG_FILE_SIZE_MB):
            self._max_log_size_mb = AgentConf.DEFAULT_LOG_FILE_SIZE_MB

        self._max_log_num = g_cfg_agentassist.get_int_option('agent_log', 'max_log_num')
        if not AgentConf.check_param(AgentConf.MIN_LOG_FILE_NUM, self._max_log_num, AgentConf.MAX_LOG_FILE_NUM):
            self._max_log_num = AgentConf.DEFAULT_LOG_FILE_NUM

    def get_logger(self, log_name=RDAGENT_LOG, log_level=logging.INFO,
                   log_path=None):
        if log_path is None:
            filename = os.path.join(self._path, log_name)
        else:
            filename = os.path.join(log_path, log_name)
        abs_filename = os.path.realpath(filename)
        logger = logging.getLogger(abs_filename)
        logger.setLevel(log_level)
        if not logger.handlers:
            file_handler = ConcurrentRotatingFileHandler(
                filename=abs_filename,
                maxBytes=self._max_log_size_mb * 1024 * 1024,
                backupCount=self._max_log_num,
                chmod=self._chmod
            )
            formatter = logging.Formatter(self._formatter_str)
            file_handler.setFormatter(formatter)

            logger.addHandler(file_handler)
        return logger
