#!/bin/bash

# Linuxel7
check_suse_ubuntu ()
{
    local Is_Suse=
    local Is_Ubuntu=
    type lsb_release  &>/dev/null
    if [ $? -eq 0 ]; then
        Is_Suse=`lsb_release -a|egrep -i "suse"`
        Is_Ubuntu=`lsb_release -a|egrep -i "ubuntu"`
    else
        Is_Suse=`cat /etc/issue|egrep -i "suse"`
        Is_Ubuntu=`cat /etc/issue|egrep -i "ubuntu"`
    fi

    local Kernel_first=`uname -r|cut -d"." -f 1`
    local Kernel_second=`uname -r|cut -d"." -f 2`
    if [ -n "${Is_Ubuntu}" ]; then
        if [ ${Kernel_first} -gt 3 ] || ([ ${Kernel_first} -eq 3 ] && [ ${Kernel_second} -ge 16 ]); then
            # Select the Linux el7 version.
            return 0
        else
            # Select the Linux 5 version.
            return 1
        fi
    fi

    if [ -n "${Is_Suse}" ]; then
        if [ ${Kernel_first} -gt 3 ] || ([ ${Kernel_first} -eq 3 ] && [ ${Kernel_second} -ge 12 ]); then
            # Select the Linux el7 version.
            return 0
        else
            # Select the Linux 5 version.
            return 1
        fi
    fi
}

check_redhat_centos ()
{
    if [ -f /etc/euleros-release ]; then
        return 0
    fi
    local kylin_version=`cat /etc/os-release | grep -i kylin |wc -l`
    local Judge_version=`cat /etc/system-release | grep -i oracle |wc -l`
    local Kernel_first=`uname -r|cut -d"." -f 1`
    local Kernel_second=`uname -r|cut -d"." -f 2`
    if [ "${Judge_version}" != "0" ]; then
        if [ ${Kernel_first} -gt 4 ] || ([ ${Kernel_first} -eq 4 ] && [ ${Kernel_second} -ge 1 ]); then
            if [ ${Kernel_first} -gt 4 ] || ([ ${Kernel_first} -eq 4 ] && [ ${Kernel_second} -ge 18 ]); then
                # Select the Linux el8 version.
                return 2
            else
                # Select the Linux el7 version.
                return 0
            fi
        else
            # Select the Linux 5 version.
            return 1
        fi
    elif [ "${kylin_version}" != "0" ]; then
        if [ ${Kernel_first} -gt 2 ] || ([ ${Kernel_first} -eq 2 ] && [ ${Kernel_second} -ge 6 ]); then
            # Select the Linux el7 version.
            return 0
        else
            # Select the Linux 5 version.
            return 1
        fi
    else
        if [ ${Kernel_first} -gt 3 ] || ([ ${Kernel_first} -eq 3 ] && [ ${Kernel_second} -ge 10 ]); then
            if [ ${Kernel_first} -gt 4 ] || ([ ${Kernel_first} -eq 4 ] && [ ${Kernel_second} -ge 18 ]); then
                # Select the Linux el8 version.
                return 2
            else
                # Select the Linux el7 version.
                return 0
            fi
        else
            # Select the Linux 5 version.
            return 1
        fi
    fi
}

select_linux_ver ()
{
    exist0=0
    exist1=1
    exist2=2
    type lsb_release  &>/dev/null
    if [ $? -eq 0 ]; then
        local Suse_Ubutu=`lsb_release -a|egrep -i "suse|ubuntu"`
        if [ -n "${Suse_Ubutu}" ];  then
            check_suse_ubuntu
            if [ $? -eq 0 ]; then
                echo "el7"
                return ${exist0}
            else
                echo "Linux_5"
                return ${exist1}
            fi
        else
            check_redhat_centos
            local right=$?
            if [ $right -eq 0 ]; then
                echo "el7"
                return ${exist0}
            elif [ $right -eq 2 ]; then
                echo "el8"
                return ${exist2}
            else
                echo "Linux_5"
                return ${exist1}
            fi
        fi
    else
        local Issue_file="/etc/issue"
        if [ -f ${Issue_file} ];  then
            local Suse_Ubutu=`egrep -i "suse|ubuntu" ${Issue_file}`
            if [ -n "${Suse_Ubutu}" ];  then
                check_suse_ubuntu
                if [ $? -eq 0 ]; then
                    echo "el7"
                    return ${exist0}
                else
                    echo "Linux_5"
                    return ${exist1}
                fi
            else
                check_redhat_centos
                local right=$?
                if [ $right -eq 0 ]; then
                    echo "el7"
                    return ${exist0}
                elif [ $right -eq 2 ]; then
                    echo "el8"
                    return ${exist2}
                else
                    echo "Linux_5"
                    return ${exist1}
               fi
            fi
        fi
    fi
}

select_linux_ver
exit 0