# -*- coding:utf-8 -*-
import os
import utils.common.log as logger
import utils.common.software_package_util as FileUtil
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.business.param_util import ParamUtil
from utils.business.manageone_util2 import ManageOneUtil2 as manageoneUtil2
from utils.common.exception import HCCIException

logger.init("eBackup")

PACKAGE_PATTERN = "^resource_10UnifiedAccess2MO_eBackup_(.*)\\.tar\\.gz$"


class RegisterAdaptationPackage(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.params = ParamUtil()
        self.region_id = self.params.get_param_value(self.pod_id, '', 'region0_id')
        super(RegisterAdaptationPackage, self).__init__(project_id, pod_id)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message(200)

    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        logger.info("begin to register eBackup adaptation package")
        try:
            (path, name, version) = FileUtil.find_software_package_by_name_re(PACKAGE_PATTERN)
        except Exception as err:
            logger.error(str(err))
            return Message(500, str(err), str(err))

        logger.info(f"upload adaptation package path:{path}, name:{name}, version:{version}")
        file_path = os.path.join(path, name)
        package_infos = {
            "regionId": self.region_id,
            "file_path": file_path
        }

        try:
            result = manageoneUtil2().upload_adaptation_package(project_id, pod_id, package_infos)
        except HCCIException as err:
            return Message(500, err)
        except Exception as err:
            logger.error(str(err))
            return Message(500, str(err), str(err))

        if result.get("status") == "failed":
            message = result.get("msg")
            logger.error(f"upload adaptation package {name} failed : {message}")
            raise HCCIException(f"upload adaptation package {name} failed : {message}")

        logger.info("End to register CloudNetDebug adaptation package to OC successfully")
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message(200)
