# -*- coding:utf-8 -*-
import utils.common.log as logger
from utils.business.dmk_util import DmkApi


class DMKTask(object):
    def __init__(self, dmk_float_ip, user, password):
        self.float_ip = dmk_float_ip
        self.login_user = user
        self.login_pwd = password
        self.dmk = DmkApi()

    def do_task(self, dmk_task, account):
        try:
            result = self.dmk.excute_dmk_deployment(app_name=dmk_task.app_name,
                                                    to_run="true",
                                                    app_version=dmk_task.app_version,
                                                    deploy_action=dmk_task.deploy_action,
                                                    hosts_content=dmk_task.host_info,
                                                    vars_content=dmk_task.config_info,
                                                    account_id=self._get_accounts(account))
        except Exception as ex:
            logger.error("Do Dmk task failed.The reason is %s" % str(ex))
            return False
        return result

    def _get_accounts(self, operation_user):
        self.dmk.login_dmk(self.float_ip, self.login_user, self.login_pwd)
        return self.dmk.get_dmk_account_id(self.login_user, operation_user)
