# -*- coding:utf-8 -*-
from collections import namedtuple
from dataclasses import dataclass


@dataclass
class Auth:
    host: str
    ssh_user: str
    ssh_pwd: str
    sudo_user: str
    sudo_pwd: str


class DMKInfo(object):

    def __init__(self, dmk_params):
        self._dmk_params = dmk_params

    @property
    def dmk_params(self):
        return namedtuple(
            "dmk_params", self._dmk_params.keys())(**self._dmk_params)


class ArbInfo(object):

    def __init__(self, arb_params):
        self._arb_params = arb_params

    @property
    def arb_params(self):
        return namedtuple(
            "arb_params", self._arb_params.keys())(**self._arb_params)


class AuthFtp(object):

    def __init__(self, host, ftp_user, ftp_pwd):
        self.host = host
        self.ftp_user = ftp_user
        self.ftp_pwd = ftp_pwd

    @property
    def auth_provider(self):
        auth = namedtuple(
            'auth', ['host', 'ftp_user', 'ftp_pwd'])
        return auth(self.host, self.ftp_user, self.ftp_pwd)


@dataclass
class PkgFileLimitInfo:
    unit: str
    size_limit: int
    file_num_limit: int


@dataclass
class SSHClientInfo:
    host_ip: str
    ssh_user: str
    ssh_pwd: str


@dataclass
class DmkInfo:
    dmk_float_ip: str
    sys_user: str
    sys_pwd: str
    deploy_user: str
    user_preset_pwd: str
    user_new_pwd: str
    deploy_group: str


@dataclass
class DmkDeploymentInfo:
    app_name: str
    to_run: bool
    app_version: str
    deploy_action: str
    hosts_content: str
    vars_content: str
    account_id: str


@dataclass
class VmScaleInfo:
    vm_id: str
    server_name: bool
    vm_group_name: str
    vm_cpu: int
    vm_mem: int
    disk: int = 0
    sys_disk: int = 0


@dataclass
class DmkAccountInfo:
    user: str
    ssh_user: str
    ssh_pwd: str
    sudo_pwd: str
    group: str


@dataclass
class LoginScWebInfo:
    console_host: str
    iam_host: str
    user: str
    pwd: str
    region_name: str
