# -*- coding:utf-8 -*-
from collections import defaultdict

import utils.common.log as logger

from plugins.eReplication.common.lib.conditions import Condition
from plugins.eReplication.common.params_check.deploy_params_check import \
    ParamCheck

logger.init("ParamsChecker")


def params_check(**kwargs):
    """插件参数校验接口函数
    :param kwargs:
    :return: 成功：True, ''， 失败：False，错误信息，格式：{key1:err_msg1, key2:err_msg2}
    """
    err_msg = defaultdict()
    project_id = kwargs.get("params").get('project_id')
    condition = Condition(project_id)
    checker = ParamCheck(kwargs, err_msg)
    should_check_quorum = condition.is_expansion_service and not (
            condition.is_csha_installed) and (
            condition.is_csha)
    if condition.global_con_dr_install_dr_service and not condition.is_expansion_service_storage:
        checker.check_lld_ips()
        if condition.is_expansion_service:
            checker.check_dns_ntp()
    should_check_primary_region_ips = condition.is_sub and condition.is_global_con_dr \
        and not condition.is_current_dr_installed \
        and not condition.is_expansion_service_storage
    if should_check_primary_region_ips:
        checker.check_primary_region_ips()
    if should_check_quorum:
        checker.check_quorum()
    if condition.is_csdr and condition.is_sub and not condition.is_expansion_service_storage:
        if condition.is_block_dr:
            checker.csdr_param_check()
        if condition.is_nas_dr:
            checker.csdr_param_check_for_nas()
    if condition.is_csha and not condition.is_expansion_service_storage:
        checker.csha_param_check()
    if condition.is_expansion_dr_service_storage:
        if condition.is_csdr:
            checker.csdr_param_check()
        if condition.is_csha:
            checker.csha_param_check()
    if condition.is_service_installed:
        checker.check_service()
    err_msg = checker.err_msg
    if len(err_msg) != 0:
        logger.error(f"Check params failed: {err_msg}.")
        return False, err_msg
    return True, ''
