# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.api.vm_api import API as VM_API
from plugins.eReplication.common.constant import Network
from plugins.eReplication.common.constant import Pkg
from plugins.eReplication.common.constant import VMName
from plugins.eReplication.common.constant import VMScale
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.model import PkgFileLimitInfo
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.os_api import API as OS_API

logger.init("CreateVM")


class CreateQuorumVM(BaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(CreateQuorumVM, self).__init__(project_id, pod_id, regionid_list)
        self.file_size_limit_gb = 5
        self.file_num_limit = 1
        nodes = Nodes(self.project_id, self.pod_id)
        self.arb_ip = nodes.arb_ip
        self.sudo_user = nodes.arb_sudo_user
        self.sudo_pwd = nodes.arb_sudo_pwd

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        pkg_file_limit_info = PkgFileLimitInfo("GB", self.file_size_limit_gb, self.file_num_limit)
        VM_API.extract_os_file(self.project_id, pkg_file_limit_info, Pkg.QUORUM_EXTRACT_PATH, Pkg.QUORUM_TEMP_NAME)
        logger.info(f"Start create vm: {self.arb_ip}.")
        result = VM_API.create_manage_vm(
            pod_id, VMName.QUORUM_NAME, VMName.GROUP_NAME,
            '2', '4', VMScale.DISK_0, [self.arb_ip], Network.OM,
            sys_disk=VMScale.DISK_20, image_file_name=Pkg.QUORUM_TEMP_NAME,
            vm_image_name=Pkg.IMAGE_NAME, availability_zone="manage-az",
            volume_type="manager.fsa.csg")
        logger.debug(f"VMS id: {result}.")
        # 虚拟机创建刚结束时，测试虚拟机是否能正常连接
        OS_API.check_os_connection(self.arb_ip, self.sudo_user, self.sudo_pwd)

    def retry(self, project_id, pod_id, *args, **kwargs):
        VM_API.delete_manage_vm(
            pod_id, VMName.QUORUM_NAME, VMName.GROUP_NAME, [self.arb_ip],
            Network.OM)
        return self.execute(project_id, pod_id)
