# -*- coding:utf-8 -*-
import abc

from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message


class BaseSubJob(StepBaseInterface):
    def __init__(self, project_id, pod_id, regionid_list=None):
        super(BaseSubJob, self).__init__(project_id, pod_id, regionid_list)
        self.project_id = project_id
        self.pod_id = pod_id
        self.regionid_list = regionid_list
        if self.regionid_list:
            self.region_id = self.regionid_list[0]

    def pre_check(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform resource pre-check before installation,
        this interface is called by the execute interface,
        The tool framework does not directly call this interface.
        """
        return Message(200)

    @abc.abstractmethod
    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform installation & configuration.
        """
        return Message(200)

    def rollback(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform job job failed rollback.
        """
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform job failed retry.
        """
        self.rollback(project_id, pod_id, regionid_list)
        return self.execute(project_id, pod_id, regionid_list)

    def check(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Check before task execution.
        """
        return Message(200)
