# -*- coding:utf-8 -*-

import utils.common.log as logger
from utils.common.check_result import CheckResult
from utils.common.exception import HCCIException

from plugins.eReplication.common.lib.model import Auth
from plugins.eReplication.common.client.ssh_client import API as SSH_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_check_result
from plugins.eReplication.common.lib.params import Nodes

logger.init("eReplication")


class CheckCommunicationMatrix(BaseSubJob):
    """校验升级过程的所需要的通信矩阵是否放开"""

    @handle_task_check_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """标准调用接口：执行安装&配置

        :param project_id:
        :param pod_id:
        :return:
        """
        logger.info("Start check communication matrix process.")
        results = list()
        check_server_res, results = \
            self.check_server_common_port(results)
        if check_server_res:
            check = CheckResult(
                itemname_ch="通信矩阵校验",
                itemname_en="Communication matrix check", status="success")
            results.append(check)
            logger.info("Check communication matrix success.")
        return results

    def check_server_common_port(self, results):
        nodes = Nodes(self.project_id, self.pod_id)
        for host in nodes.all_hosts:
            ssh_client = None
            try:
                ssh_client = SSH_API.get_sudo_ssh_client(Auth(host, nodes.ssh_user, nodes.ssh_pwd, nodes.sudo_user,
                                                              nodes.sudo_pwd))
            except Exception as err_msg:
                logger.error(
                    f"Failed to connect to the Server node using SSH, "
                    f"reason is: {str(err_msg)}.")
                check = CheckResult(
                    itemname_ch="通信矩阵校验",
                    itemname_en="Communication matrix check",
                    status="failure", error_msg_cn=HCCIException(
                        675032, str(err_msg)))
                results.append(check)
                return False, results
            finally:
                SSH_API.close_ssh(ssh_client)
        return True, results
