# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.cipher_api import API as CIPHER_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_check_result

logger.init("eReplication")


class CheckEnv(BaseSubJob):

    @handle_task_check_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """标准调用接口：执行安装&配置

        :param project_id:
        :param pod_id:
        :return:
        """

        cipher_api = CIPHER_API(self.project_id, self.pod_id, self.region_id)
        check_result = cipher_api.check_environment()
        cipher_api.check_cipher_type()
        return check_result
