# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.constant import NOVA_CERT_TYPE
from plugins.eReplication.common.cert_api import API as CERT_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result

logger.init("ImportCerts")


class ImportCerts(BaseSubJob):
    """
    导入OpenStack证书
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        CERT_API.get_nova_cert(self.project_id, self.pod_id)
        CERT_API.import_sys_cert(self.project_id, self.pod_id, NOVA_CERT_TYPE)
